/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/


#ifndef TSUN_H
#define TSUN_H

const double kDegRad = 0.0174532925199432958;
const double kPI = 3.141592653589793;

class Tsun {
public:
	Tsun (int iMonth, int iDay, int iHour, int iMinute, double dLatitude);
	Tsun (double dAltitude, double dAzimuth);
	~Tsun ();

	void calcAltitudeAzimuth (void);

	double altitude (void) const	{return (fAltitude);}
	double azimuth (void) const		{return (fAzimuth);}

private:
	static int fDayMonths[];
	int		fMonth;
	int		fDay;
	int		fHour;
	int		fMinute;
	double	fLatitude;	// degrees.minutes
	double	fAltitude;
	double	fAzimuth;
};

#endif
