/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef __AL_VECTOR
#define __AL_VECTOR
#include <math.h>

//
// quickie vector library
//
class AlVector
{
public:
	double x, y, z;

public:
	AlVector();
	AlVector( const AlVector & v);
	AlVector( double, double, double );
	AlVector( const double array[3] );
	~AlVector();

	AlVector&	operator =( const AlVector &);

	int			operator ==( const AlVector& ) const;
	int			operator !=( const AlVector& ) const;

	AlVector&	operator +=( const AlVector& );	// add
	AlVector&	operator -=( const AlVector& );	// subtract
	AlVector&	operator *=( const double );	// scale 
	AlVector&	operator /=( const double );	// scale
	AlVector&	operator ^=( const AlVector& );	// vector product

	AlVector	operator +( const AlVector& ) const;
	AlVector	operator -( const AlVector& ) const;
	double		operator *( const AlVector& ) const;
	AlVector	operator ^( const AlVector& ) const;
	AlVector	operator *( const double ) const;
	AlVector	operator /( const double ) const;
	AlVector	operator -() const;

	friend AlVector operator *( const double d, const AlVector& v);

	double		size( ) const;
	AlVector	norm() const;
	void		put( double array[3] ) const;
};
#endif
