/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _statusCodes
#define _statusCodes

typedef long statusCode;

/* Universal statusCodes */
enum {
	sSuccess = 0,
	sFailure = 1,
	sInsufficientMemory,
	sInvalidArgument,
	sNameChangedToUniqueOne,
	sAlreadyCreated,
	sNoProjectEnvironment,
	sCannotDelete,
	sNoParent,
	sInvalidObject,

	sObjectInSet,				/* statusCodes for class AlSet */
	sObjectInAnotherSet,
	sObjectInExclusiveSet,
	sObjectAncestorInSet,
	sObjectDescendentInSet,
	sObjectNotAMember,

	sInvalidWireFile,

	/*
	// Expression system statusCodes
	*/

	sExprNotValidName,
	sExprNotDagObject,
	sExprNotValidCV,
	sExprNotValidParameter,
	sExprNotValidRelative,
	sExprBadVariable,
	sExprAxInsertBadRef,
	sExprAxInsertSelfRef,
	sExprAxInsertCircRef,
	sExprParseError,

	sAlreadyTrimmed,

	sObjectNotFound,
	sObjectAlreadyPresent,

	sEndOfGlobalCodes		/* don't put any codes after this */
};

#endif	/* _statusCodes */
