/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

/*
//
//	.NAME AlWindow - interface to the Alias modeling windows.
//
//	.SECTION Description
//		Alias modeling windows are the windows in which geometry information
//		is actually viewed and modified.  These are the Top, Front, Right
//		and Perspective windows, as well as the SBD window.  This class
//		allows the creation, positioning and sizing windows.  You can get
//		the camera associated with a window.  Plugins can use the mapping
//		functions to determine where in world space a screen event occurred.
//
//		AlUniverse contains methods for getting the first modeling window,
//		the current modeling window, and the sbd window.
//
*/

#ifndef _AlWindow
#define _AlWindow

#include <AlObject.h>
#include <AlAnimatable.h>

class STUDIOAPI_DECL AlWindow 	: public AlObject , public AlAnimatable {
	friend						class AlFriend;

public:

	enum AlViewType {
		kViewInvalid,
		kViewOther,
		kFront,
		kBack,				/* unused */
		kRight,
		kLeft,				/* unused */
		kTop,
		kBottom,			/* unused */
		kSbd,
		kPerspective
	};

	enum AlCornerType {
		kBottomLeft,
		kTopLeft,
		kTopRight,
		kBottomRight
	};

	enum AlAspectType {
		kNoScale,
		kScaleY,
		kScaleX
	};

public:
								AlWindow();
	virtual 					~AlWindow();

	virtual AlObjectType		type() const;

	statusCode					create( AlViewType );
	virtual AlObject*			copyWrapper() const;
	virtual statusCode			deleteObject();


	AlWindow*					next() const;
	AlWindow*					prev() const;

	statusCode					nextD();
	statusCode					prevD();

	statusCode					windowType( AlViewType& ) const;
	statusCode					isZoom( API_BOOLEAN& );
	
	statusCode					isVisible( API_BOOLEAN& );

	statusCode                  orthographic( API_BOOLEAN & ) const ;
	AlCamera*					camera( void );
	statusCode					setCamera( AlPerspectiveCamera* );

	statusCode					position( Screencoord&, Screencoord& );
	statusCode					setPosition( Screencoord, Screencoord );

	statusCode					resolution( Screencoord&, Screencoord& );
	statusCode					setResolution( Screencoord, Screencoord, AlCornerType = kTopLeft, AlAspectType = kNoScale );

	statusCode 					priority( int& );
	statusCode					setPriority( int );

	double						gridSize();
	statusCode					setGridSize( double size );

	statusCode					mapToWorldSpace( Screencoord, Screencoord, double&, double&, double&, double&, double&, double& );
	statusCode					worldSpaceBounds( double&, double&, double&, double&, double&, double& );

	static statusCode			aliasWindowSize( int&, int& );
	static statusCode			aliasWindowPosition( int&, int& );

#ifndef WIRE_LIBRARY
    static void                 createDefaultWindows ( void );
#endif

private:
	virtual	API_BOOLEAN extractType( int&, void*&, void*& ) const;

	static void					initMessages( void );
	static void					finiMessages( void );
};

#endif /* _AlWindow */
