/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlVolumeLight - Encapsulates the functionality common to all volume lights.
//
//	.SECTION Description
//
//		There are two ways that this class is used.  If the user
//		instantiates and calls the create method on an AlVolumeLight,
//		the resulting object is a box volume light. This light has
//		all the special effects parameters in a cubical volume.
//
//		Alternatively, the  user could instantiate and create an
//		AlSphereLight, AlCylinderLight, AlTorusLight, AlConeLight or AlBoxLight
//		(which are all considered "volume" and which are all derived from
//		this light class).
//
//		Note that volume lights differ in thir shape, the way that their
//		direction components are interpreted with respect to that shape,
//		and the way that dropoff and decay are applied.
//


#ifndef _AlVolumeLight
#define _AlVolumeLight

#include <AlNonAmbientLight.h>

class AlLightNode;

class STUDIOAPI_DECL AlVolumeLight: public AlLight {

public:
	virtual					~AlVolumeLight();

	virtual	AlObject*		copyWrapper() const;

	virtual	AlObjectType	type() const;

	API_BOOLEAN					shadows() const;
	API_BOOLEAN					specular() const;
	API_BOOLEAN					turbulenceAnimated() const;
	API_BOOLEAN					turbulenceDirectional() const;
	int						turbulenceSpaceRes() const;
	int						turbulenceTimeRes() const;
	double					intensity() const;
	double					decay() const;
	double					decayStart() const;
	double					directionality() const;
	double					concentric() const;
	double					directional() const;
	double					radial() const;
	double					dropoff() const;
	double					dropoffStart() const;
	double					turbulenceIntensity() const;
	double					turbulenceSpread() const;
	double					turbulencePersistance() const;
	double					turbulenceGranularity() const;
	double					turbulenceRoughness() const;
	double					turbulenceVariability() const;

	statusCode				setShadows(API_BOOLEAN);
	statusCode				setSpecular(API_BOOLEAN);
	statusCode				setTurbulenceAnimated(API_BOOLEAN);
	statusCode				setTurbulenceDirectional(API_BOOLEAN);

	statusCode				setTurbulenceSpaceRes(int);
	statusCode				setTurbulenceTimeRes(int);

	statusCode				setIntensity( double );
	statusCode				setDecay(double);
	statusCode				setDecayStart(double);
	statusCode				setDirectionality(double);
	statusCode				setConcentric(double);
	statusCode				setDirectional(double);
	statusCode				setRadial(double);
	statusCode				setDropoff(double);
	statusCode				setDropoffStart(double);
	statusCode				setTurbulenceIntensity(double);
	statusCode				setTurbulenceSpread(double);
	statusCode				setTurbulencePersistance(double);
	statusCode				setTurbulenceGranularity(double);
	statusCode				setTurbulenceRoughness(double);
	statusCode				setTurbulenceVariability(double);

protected:

	// This class is a pure virtual class.  It cannot
	// be instantiated.
	//
							AlVolumeLight();
};
#endif
