/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

/*
//
//	.NAME AlViewFrame - All the methods to do a viewframe operation.
//
//	.SECTION Description
//		This is a static class in that all of its member functions are
//		static.  It provides the functionality to do a viewframe on
//		the entire universe or a single file.
//
//		When doing a viewframe it is important to remember that if
//		the model contains construction history, fillet surfaces
//		may be recreated. As a result, any existing AlSurfaceCVs
//		from these surfaces will no longer be valid after the
//		viewframe. They will not be deleted, but will instead be
//		made inactive; all their methods will fail. Any object can
//		be tested to see whether it is no longer active with the
//		isValid() method. An inactive object may be deleted, or
//		all inactive objects may be deleted with the
//		AlUniverse::cleanUpUniverse() method. Please see the
//		documentation on AlUniverse::cleanUpUniverse() for
//		its possible side affects.
//
*/

#ifndef _AlViewFrame
#define _AlViewFrame

#include <AlStyle.h>

class AlSurface;
class AlCurve;
class AlAnimatable;

struct Dag_node;

class STUDIOAPI_DECL AlViewFrame {
public:
	enum Options
	{
		kObject,
		kObjectAndAbove,
		kObjectAndBelow,
		kObjectAndAboveBelow
	};

	static statusCode 	viewFrame(const double);
	static statusCode	viewFrame(AlAnimatable*, const double,Options=kObject);
	static statusCode	viewFrame(AlSurface*, const double, Options=kObject);
	static statusCode	viewFrame(AlCurve*, const double, Options=kObject);
};

#endif // _AlViewFrame

