/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlVertexDataList - Interface to Alias polyset ST's and Normals.
//
//	.SECTION Description
//
//		WARNING: AlVertexDataList is deprecated, use AlMesh instead.
//
//		AlVertexDataList is an optional additional interface to Alias's
//		per-vertex-per-poly ST and Normal data. It provides an output
//		only format for this data similar to that used by Wavefront's
//		.obj file format.
//		.br
//		The user can use this class to obtain a list of ST's and Normals
//		used by the polyset, and also may find out which normals or
//		ST's are used by each polygon in the polyset as an index into
//		this shared table.
//		.br
//		Note that this data is read-only, and is NOT automatically updated
//		if the source polyset is changed.
//

#ifndef _AlVertexDataList
#define _AlVertexDataList

#include <AlStyle.h>

class AlPolyset;
class PS_Polyset;
class STUDIOAPI_DECL AlVertexDataList {
	friend		class AlPolyset;

public:
				AlVertexDataList( AlPolyset *pset );
				~AlVertexDataList();

	int			STListSize();
	int			normalListSize();

	API_BOOLEAN		STByIndex( int index, float &s, float &t );
	API_BOOLEAN		normalByIndex( int index, float &x, float &y, float &z );

	int			vertexNormalIndex( int polygon, int vertex  );
	int			vertexSTIndex( int polygon, int vertex );

private:
	PS_Polyset*	fPolyset;
};
#endif
