/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlUserPickList - An AlList for maintaining AlUserPickItems.
//
//	.SECTION Description
//		This class is simply an AlList which maintains a list of
//		AlUserPickItems, but with one addition, it is possible to
//		set a key state for the list, where the key state is one
//		of the kModifier #defines found in AlFunction.h (i.e.
//		kModifierControl, kModifierShift, kModifierAlt, etc.). This
//		allows for indicating to the selection code what modifier
//		keys were pressed during the selection.
//

#ifndef _AlUserPickList
#define _AlUserPickList

#include <AlList.h>

class STUDIOAPI_DECL AlUserPickList : public AlList {
	public:
						AlUserPickList( int keyState = 0 ) : fState(keyState) {}
		virtual			~AlUserPickList();
		int				state() { return fState; }
		void			setState( int keyState ) { fState=keyState; }

	private:
		int				fState;
};

#endif
