/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlUserPickItem - An item of a list maintaining AlPickable objects.
//
//	.SECTION Description
//		This class is used in a list of objects maintained for the
//		AlPickList::asynchronousPick() method. It is derived from
//		AlLinkItem.
//

#ifndef _AlUserPickItem
#define _AlUserPickItem

#include <AlLinkItem.h>

struct Dag_node;
class AlPickable;

class STUDIOAPI_DECL AlUserPickItem : public AlLinkItem
{
		friend class	AlFriend;

	public:
						AlUserPickItem( AlPickable& );
		virtual			~AlUserPickItem();
		AlUserPickItem*	nextItem() { return (AlUserPickItem *) next(); }
		AlUserPickItem*	prevItem() { return (AlUserPickItem *) prev(); }

	protected:
		API_BOOLEAN			data( int&, void*&, Dag_node*& );
						AlUserPickItem( int, void*, Dag_node* );

	private:
		Dag_node*		fParent;
		void*			fItem;
		int				fType;
};

#endif
