/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//+
//
//	.NAME AlUnits - interface to units
//
//	.SECTION Description
//		This class provides access to linear and angular units in the Alias api.
//		Note that all of the internal geometry routines work in centimeters
//		and degrees.  If you wish to use other units for distance tolerances
//		and lengths, they must be explicity to centimeters.  Similarly
//		all angles will have to be converted to degrees.
//

#ifndef	_al_units
#define _al_units

#include <AlStyle.h>

class STUDIOAPI_DECL AlUnits
{
public:
	enum Type
	{
		kUnit, kSubunit, kPosition
	};

	enum LinearUnit
	{
		kMiles, kYards, kFeet, kInches,
		kKilometers, kMeters, kCentimeters, kMillimeters
	};
	enum AngularUnit
	{
		kRadians, kDegrees, kMinutes, kSeconds
	};

	static AngularUnit	angularUnits( Type type );
	static double		angularScale( Type type );

	static LinearUnit	linearUnits( Type type );
	static double		linearScale( Type type );

	static double		linearInCM( LinearUnit unit );
	static double		angularInDegrees( AngularUnit unit );

	static statusCode	parseStringAngular( const char* string, char* &ret, const char* format=0 );
	static statusCode	parseStringLinear( const char* string, char* &ret, const char* format=0 );
	static statusCode	parseStringNoUnits( const char* string, char* &ret, const char* format=0 );
};

#endif
