/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlTrimCurve - A curve in parametric surface space, part of a trim boundary.
//
//	.SECTION Description
//		This class holds the trim curve data and provides access methods
//		for the data.  A trim curve is defined over a surface's parametric
//		space.
//

#ifndef _AlTrimCurve
#define _AlTrimCurve

#include <AlObject.h>
#include <AlModel.h>

class AlTM;
class AlTrimRegion;
class AlTrimBoundary;
class AlTrimRegion;
class AlDagNode;

class STUDIOAPI_DECL AlTrimCurve : public AlObject {
	friend class			AlFriend;
	friend class			AlTrimBoundary;
	friend class			AlSurface;

public:
	virtual					~AlTrimCurve();
	virtual AlObject*		copyWrapper() const;

	virtual AlObjectType	type() const;

	AlTrimBoundary*			parentBoundary() const;
	AlTrimRegion*			parentRegion() const;
	AlDagNode*				parentDagNode() const;

	AlCurve* 				worldSpace3DCopy( double = 1.0e-5 ) const;
	AlCurve* 				unaffected3DCopy( double = 1.0e-5 ) const;
	AlCurve* 				unaffected3DCopyNoReverse( double = 1.0e-5 ) const;
	AlCurve* 				affected3DCopy( AlTM&, double = 1.0e-5 ) const;

	AlTrimCurve*			getTwinCurve() const;

	API_BOOLEAN					isReversed() const;
	curveFormType			form() const;
	int						degree() const;
	int						numberOfSpans() const;
	int						numberOfKnots() const;
	int						numberOfCVs() const;

	statusCode				eval(double, double*, double*, double*) const;
	statusCode				CVsUVPosition( double[], double[][3] ) const;
	int						realNumberOfKnots() const;
	statusCode				realKnotVector( double[] ) const;

	statusCode 				periodicToNonPeriodic( ) const;

	AlTrimCurve*			nextCurve() const;
	statusCode				nextCurveD();

	AlTrimCurve*			prevCurve() const;
	statusCode				prevCurveD();

protected:
							AlTrimCurve( void*, void* );
private:
	void*					fSpline;
	void*					fParent;
};

#endif
