/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlTrimBoundary - A list of trim curves defining a trim boundary.
//
//	.SECTION Description
//		This class holds a list of AlTrimCurve objects.  The trim curves
//		form a closed boundary which partition a surface. The trim curves
//		are defined in a surface's parametric space.
//
//		Note that trim boundaries have the surface to the right of the
//		defining curves.
//
//		Also, in the list of trim curves, the end point of a trim curve
//		is coincident with the first point of its following trim curve.
//		The end point of the last trim curve is coincident with the
//		first point of the first trim curve.
//

#ifndef _AlTrimBoundary
#define _AlTrimBoundary

#include <AlObject.h>

class AlIterator;
class AlTrimRegion;
class AlTrimCurve;

struct Spline_surface;

class STUDIOAPI_DECL AlTrimBoundary : public AlObject {
	friend class			AlFriend;

public:
	virtual					~AlTrimBoundary();
	virtual AlObject*		copyWrapper() const;

	virtual AlObjectType	type() const;

	AlTrimRegion*			parentRegion() const;
	AlDagNode*				parentDagNode() const;

	AlTrimCurve*			firstCurve() const;
	statusCode				applyIteratorToCurves( AlIterator*, int& );

	AlTrimBoundary*			nextBoundary() const;
	statusCode				nextBoundaryD();

	AlTrimBoundary*			prevBoundary() const;
	statusCode				prevBoundaryD();

	statusCode				convertToUVPolyline( int &np, double *&CVList );
protected:
							AlTrimBoundary( Spline_surface * );
private:
	Spline_surface*			fParent;
};

#endif
