/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

/*
//
//	.NAME AlTesselate - All the methods to tesselate geometry.
//
//	.SECTION Description
//
//		WARNING: Several tessellation methods in this class generate
//		polyset objects, which are deprecated (uniform, adaptive,
//		number, rendererSettings, and chordHeightDeviation).  It is
//		recommended that you use chordHeightDeviationFast or
//		chordHeightDeviationAccurate, which generate meshes.
//
//		This is a static class in that all of its member functions are
//		static.  It provides the functionality to tesselate geometry.
//
//		The methods in this library will generate meshes or polysets
//		from the geometry below the AlDagNode, composed of either
//		triangles or quadrilaterals based on the type argument to the
//		method (either kTESSELATE_TRIANGLE or kTESSELATE_QUADRILATERAL).
//
//		Note that when tesselating a trimmed surface some triangles
//		may be created along the trim edge even though quadrilateral
//		tesselation was selected.
*/

#ifndef _AlTesselate
#define _AlTesselate

typedef enum
	{ kTESSELATE_TRIANGLE, kTESSELATE_QUADRILATERAL }
AlTesselateTypes;

#include <AlStyle.h>

struct PS_ConversionParams;
struct Dag_node;

class AlDagNode;


class STUDIOAPI_DECL AlTesselate {
public:

	static statusCode	uniform(AlDagNode* &, const AlDagNode*, AlTesselateTypes = kTESSELATE_TRIANGLE, int = 2, int = 2);
	static statusCode	adaptive(AlDagNode* &, const AlDagNode*, AlTesselateTypes = kTESSELATE_TRIANGLE, int = 2, int = 4, double = 0.6, int = 2);
	static statusCode	number(AlDagNode* &, const AlDagNode*, AlTesselateTypes = kTESSELATE_TRIANGLE, int = 512, int = 32, double = 0.001);

	static statusCode	rendererSettings( AlDagNode* &, const AlDagNode*, AlTesselateTypes = kTESSELATE_TRIANGLE );

	static statusCode	chordHeightDeviation( AlDagNode * &, const AlDagNode*, double tolerance = .01 );

    static statusCode	chordHeightDeviationFast( AlDagNode * &, const AlDagNode*, double tolerance = .01 );
    static statusCode	chordHeightDeviationAccurate( AlDagNode * &, const AlDagNode*, double tolerance = .01 );
};

#endif /* _AlTesselate */
