/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//+
//	.NAME AlSurfacePoint - Interface to Alias Surface points.
//
//	.SECTION Description
//		A point can be created in the parametric space of any AlSurface. This
//		point can be queried for the surface normal, tangents, position in
//		world coordinate system, arc lengths, and curvatures. This class contains
//		methods for creating, and moving the surface point.
//
//		If the AlSurface is deleted, the surface point created on it is
//		automatically deleted.

#ifndef __AlSurfacePoint
#define __AlSurfacePoint


#include <AlPoint.h>

class AlSurfaceNode;

class STUDIOAPI_DECL AlSurfacePoint : public AlPoint {
	friend class			AlFriend;

public:

	AlSurfacePoint();
	~AlSurfacePoint();

	virtual AlObject *	    copyWrapper() const;
	virtual AlObjectType	type() const;
	statusCode		        create(const AlSurface *, double, double);
	
	statusCode		        setParameter(double, double);
	statusCode		        parameter(double &, double &) const;
	
	virtual statusCode		worldPosition(double &, double &, double &) const;
	
	statusCode              uTangent(double &, double &, double &) const;
	statusCode              vTangent(double &, double &, double &) const;
	
	statusCode              normal(double &, double &, double &) const;
	
	statusCode              meanRadius(double &) const;
	
	statusCode              gaussianRadius(double &) const;
	
	statusCode              principalMinimumRadius(double &) const;
	
	statusCode              principalMaximumRadius(double &) const;
	
	statusCode              uArcLength(double &) const;
	statusCode              vArcLength(double &) const;
	
	AlSurfaceNode *			attachedTo();

};

#endif




















