/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlSurfaceNode
#define _AlSurfaceNode

//
//	.NAME AlSurfaceNode - Dag node class for nurbs surfaces.
//
//	.SECTION Description
//		AlSurfaceNode is the class used to access and manipulate
//		surfaces within the dag.
//		This class behaves like other dag nodes (see AlDagNode for a
//		description of the usage and purpose of dag nodes)
//		and in addition allows users
//		to add curves on surfaces and access the geometry of the surface
//		via the surface() method.  The surface() method returns a
//		pointer to an AlSurface object which provides the user with
//		the methods used to modify the geometry of the surface.
//		Surfaces can be created from scratch by calling
//		the AlSurfaceNode::create() method,
//		or read in from a wire file (see AlUniverse documentation).
//

#include <AlDagNode.h>

class AlSurface;

class STUDIOAPI_DECL AlSurfaceNode : public AlDagNode {
	friend class			AlFriend;

public:
							AlSurfaceNode();
	virtual					~AlSurfaceNode();
	virtual AlObject*		copyWrapper() const;

	statusCode				create( AlSurface * );

	virtual AlObjectType	type() const;

	AlSurface*				surface() const;
	AlSurface*				surface(AlTM&) const;

	int						patchPrecision() const;
	statusCode				setPatchPrecision( int precision );

  private:
};

#endif
