/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

#ifndef _AlStyle
#define _AlStyle

#if defined( _WIN32 )

# if defined( API_STUDIO )
#  define STUDIOAPI_DECL __declspec( dllexport )
# else
#  define STUDIOAPI_DECL __declspec( dllimport )
# endif
#elif defined(AW_HIDE_SYMBOLS)
# define STUDIOAPI_DECL __attribute__ ((visibility("default")))
#else
# define STUDIOAPI_DECL
#endif /* _WIN32 */

#if defined(_WIN32)
 #define UC_BOOLEAN			// Control boolean type definition on Win32
#endif

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>

#ifndef _statusCodes
#	include <statusCodes.h>
#endif

// ALIAS_BOOLEAN_WORKAROUND is used here to get around
// a build problem of catia v5 and open model we introduce the
// name space to give the compiler a chance to decide. This is done
// this way to allow us to build catv5 against currently shipping V11
// libraries the real fix is to get rid of boolean altogether 
#ifndef API_BOOLEAN
	#ifndef UC_BOOLEAN
        #ifdef ALIAS_BOOLEAN_WORKAROUND
           namespace awAPI
		   {
	          typedef int boolean;
		   } 
           #define API_BOOLEAN awAPI::boolean
        #else
           typedef int boolean;
           #define API_BOOLEAN boolean
        #endif // ALIAS_BOOLEAN_WORKAROUND
	#else
        #ifdef ALIAS_BOOLEAN_WORKAROUND
           namespace awAPI
		   {
    		typedef unsigned char boolean;
		   }
           #define API_BOOLEAN awAPI::boolean
        #else
           typedef unsigned char boolean;
           #define API_BOOLEAN boolean
        #endif // ALIAS_BOOLEAN_WORKAROUND
	#endif // UC_BOOLEAN
#endif // API_BOOLEAN


#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif

typedef short Screencoord; /* from gl.h */


// A few useful defines to help unify the Unix/NT

#if defined(_WIN32)
#	define SEPARATOR_STR	"\\"
#	define SEPARATOR_C		'\\'
#else
#	define SEPARATOR_STR	"/"
#	define SEPARATOR_C		'/'
#endif
#define SEPARATOR_S SEPARATOR_STR


#endif	/* _AlStyle */
