/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlStoreOptions - A structure used to transfer options that control
//		  the AlUniverse::store() method.
//
//	.SECTION Description
//		An AlStoreOptions structure is used set or determine the options
//		that the AlUniverse::store() method uses to tailor the export
//		of files.
//		To avoid setting all of the fields of AlStoreOptions using
//		AlUniverse::setStoreOptions(), it is recommended that the
//		current values be acquired first using AlUniverse::storeOptions().
//
// .br
//		For example:
//
//	.nf
//		// No error checking is done here for brevity in the example.
//		AlStoreOptions	options;
//		AlUniverse::storeOptions( options );
//		options.autocad.units = k_millimeters;
//		options.autocad.in_create_shaders = True;
//		AlUniverse::setStoreOptions( options );
//
//	.fi
//		See File->Store in the Alias manuals for a more detailed
//		description of these options.
//


#ifndef _AlStoreOptions
#define _AlStoreOptions

typedef struct AlStoreOptions {
 
/* Wire File options */
	struct _wire {
        API_BOOLEAN embedImageReferences;     
        API_BOOLEAN includeInstalledImages ;  
	} wire;

/* IGES File options */
	struct _iges {
        int surf_type; 	// IGES_OUT_SURFACE_TYPE
	                    // 0-1  Trimmed surface entity type:
	                    //    0 = output Trimmed Parametric Surface (144).
	                    //    1 = output Bounded Surface (143). 
        int out_style;  // IGES_OUT_OUTPUT_STYLE)
	                    // 0-1 Surface output style:
	                    //    0 Preserve surfaces
	                    //    1 Convert to curves
        float store_scale; 	// Scale Factor:
	                        // IGES_OUT_SCALE
        int significant_digits; // Significant Digits:
                                // IGES_OUT_PRECISION
	                            // 1-15 the number of digits of double precision.
                                // m_out_precision = 12
        int units; // 1 = Microns, 2 = Millimeter, 3 = Centimeter, 4 Meter, 
                   // 5 = Kilometer, 6 Microinch, 7 = Mils, 8 = Inch, 9 = Feet, 10 = Miles
        int version;  // 6 = V4, 8 = V5, 11 = 5.3
        API_BOOLEAN exportLogFile; 
	} iges;

/* VDA-IS File options  - see IGES options for field descriptions */
	struct _vdais {
        int surf_type; 	
        int out_style;  
        float store_scale; 	
        int significant_digits;
        int units;
	} vdais;

/* C4X File options  - see IGES options for field descriptions */
	struct _c4 {
        int surf_type; 	
        int out_style;  
        float store_scale; 	
        int significant_digits;
        int units;
	} c4;

/* JAMA-IS File options  - see IGES options for field descriptions */
	struct _jamais {
        int surf_type; 	
        int out_style;  
        float store_scale; 	
        int significant_digits;
        int units;
	} jamais;

/* VDAFS File options  - see IGES options for field descriptions */
	struct _vdafs {
        float store_scale; 	
	} vdafs;

/* JT File options */
	struct eai_jt {
        int OrganizeFirst;  // Organize first by Geometry = 0, Shader = 1, Layer = 2, SBD = 3
        int OrganizeSecond; // Organize second by Shader = 1, Layer = 2
        API_BOOLEAN OrganizeSort; // sort data by name
        API_BOOLEAN MultFile; // create a single DirectModel file
        API_BOOLEAN Curves;  // output curves
        int Symmetry; // Off=0, Merged=1, Unmerged=2
        API_BOOLEAN Invisible; // output curves
        API_BOOLEAN Template; // output curves
        API_BOOLEAN Lights; // output lights
        API_BOOLEAN Cameras; // output cameras
        API_BOOLEAN Shaders; // output shaders
        API_BOOLEAN Textures; // output textures
        API_BOOLEAN exportLogFile;  // output logfile
        float Scale;  // geometry scale factor
        int Res_image;  // texture file image resolution
        int Geo_Type; //  poly(0 default), poly+brep(1), brep(2 hidden)  
        int Brep_Type; // xtbrep(0 default), -jtbrep(1)
        int Tess_Type; // current(1),  aruba(2 default),  optimizer(3)
        float tessTol;  // tolerance for AG or Optimizer   (LOD 0) 
        float tessTol1; // tolerance for AG or Optimizer   (LOD 1) 
        float tessTol2; // tolerance for AG or Optimizer   (LOD 2) 
        int tessLOD; // tessellation LOD	
        int   Tess_Res; //Coarse(1)/Medium(2)/Fine(3)/User-Defined(0) Resolution
        float TessAngular; // angluar value for tessellation
        float TessIntAngle; // minimum size of interior angles
        float TessChordal; // chordal value for tessellation  
        float TessAspRatio; //  maximum aspect ratio for tessellation
        float TessLength; // edge length value for tessellation 
        API_BOOLEAN TriStripOpt;
        API_BOOLEAN ChorRelative;
	} eai_jt;

/* JT File options */
    struct _jt_atf {
        API_BOOLEAN    store_want_log;
        API_BOOLEAN    store_layers;
        API_BOOLEAN    store_empty_layers;
        API_BOOLEAN    store_symmetry;
        API_BOOLEAN    store_instances;
        API_BOOLEAN    store_templates;
        API_BOOLEAN    store_topology;
        API_BOOLEAN    store_divide_periodic;
        API_BOOLEAN    store_divide_multiknots;
        API_BOOLEAN    store_tessellation;
        int     store_tess_type;
        float   store_tess_tolerance;
        int     store_trim_curve_type;
        API_BOOLEAN    store_curves;
        API_BOOLEAN    store_meshes;
        API_BOOLEAN    store_cameras;
        API_BOOLEAN    store_invisible;
        int     store_file_version;
        API_BOOLEAN    store_want_XTBrep;
        int     store_parasolid_repair_type;
        int     store_parasolid_repair_level;
        int     store_geometry_type;
        API_BOOLEAN    store_use_tighter_edgecurve_tol;
    } jt_atf;

    /* Granite (ATF) File options */
    struct _granite_atf {
        API_BOOLEAN    store_want_log;
        API_BOOLEAN    store_layers;
        API_BOOLEAN    store_empty_layers;
        API_BOOLEAN    store_symmetry;
        API_BOOLEAN    store_instances;
        API_BOOLEAN    store_templates;
        API_BOOLEAN    store_topology;
        API_BOOLEAN    store_divide_periodic;
        API_BOOLEAN    store_divide_multiknots;
        // Not exposed
        //API_BOOLEAN    store_tessellation;
        //int            store_tess_type;
        //float          store_tess_tolerance;
        //int            store_trim_curve_type;
        API_BOOLEAN    store_curves;
        API_BOOLEAN    store_meshes;
        API_BOOLEAN    store_cameras;
        API_BOOLEAN    store_invisible;
        int            store_file_version;
        int            store_file_type;
    } granite_atf;

/* CATV5 File options  - Catia Version 5 */
	struct _catv5 {
        API_BOOLEAN exportConS;
        API_BOOLEAN exportMeshes;
        API_BOOLEAN exportAnnotations;
        API_BOOLEAN exportSymmetry;
        API_BOOLEAN exportInvisible;
        API_BOOLEAN exportInfinites;
        API_BOOLEAN dividePeriodic;
        API_BOOLEAN divideMultiKnots;
        int fileRelease;  // (10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,23,24) Default = 24
        API_BOOLEAN joinShell;
        int exportLogFile;
	} catv5;

    struct _catiav5_atf {
        int         store_log;
        API_BOOLEAN store_empty_layers;
        API_BOOLEAN store_symmetry;
        API_BOOLEAN store_meshes;
        API_BOOLEAN store_infinites;
        API_BOOLEAN store_invisible;
        int         store_trim_curve_type;
        API_BOOLEAN store_divide_periodic;
        API_BOOLEAN store_divide_multiknots;
        int         store_file_version;
        API_BOOLEAN store_annotations;
        API_BOOLEAN store_topology;
        API_BOOLEAN store_curves;
        API_BOOLEAN store_curve_on_surface;
        API_BOOLEAN store_instances;
        API_BOOLEAN store_templates;
        API_BOOLEAN store_cameras;
        API_BOOLEAN store_shaders;
        API_BOOLEAN store_shaders_to_geom_sets;
        API_BOOLEAN store_tessellation;
        int         store_tess_type;
        float       store_tess_tolerance;
    } catiav5_atf;

/* DWG/DXF File options */
	struct _autocad {
		/*
		 * dwg and dxf export use the same translator but they each owns
		 * different option values because they have separate UIs.
		 */
        API_BOOLEAN		wantCurves_dwg;
        API_BOOLEAN		splitG1Breaks_dwg;
        int			    version_dwg; // 14 (1), 2000 (2), 2004 (3), 2007 (4), 2010 (5), 2013 (6)
        API_BOOLEAN		wantCurves_dxf;
        API_BOOLEAN		splitG1Breaks_dxf;
        int			    version_dxf; // 12 (0), 2000 (2), 2004 (3), 2007 (4), 2010 (5), 2013 (6)
        int file_type; //  0-dwg, 1-dxf
	} autocad;
   
    struct _level_map {
        int iges_layer_or_set;          /* == kLayer create layer from level  */
                                        /* == kSet create set from level      */
                                        /* == kLayerAndSet create layer and   */
		                                /*    set from level                  */
                                        /* == kNoLayerOrSet no mapping        */
        int vdais_layer_or_set;         /* See IGES description of this field */
        int jamais_layer_or_set;        /* See IGES description of this field */
    } level_map;

    struct _trimming_map {
        int iges_default_trim;               /* == kParameter trim with parameter  */
		                                     /*    space curves                    */  
                                             /* == kWorld trim with world space    */
		                                     /*    curves                          */
		                                     /* == kUseFlag use preference flag in */
		                                     /*    file                            */
        int vdais_default_trim;              /* See IGES description of this field */
        int c4_default_trim;                 /* See IGES description of this field */
        int jamais_default_trim;             /* See IGES description of this field */
        int vdafs_default_trim;              /* See IGES description of this field */
		                                     /* kUseFlag is not valid for vdafs    */
    } trimming_map;

    struct _edf {
	       API_BOOLEAN store_want_groups;
           API_BOOLEAN store_want_log;
           int         store_layer_order_method;
	} edf;

    struct _fbx {
           API_BOOLEAN store_want_log;
           API_BOOLEAN store_want_curves;
           API_BOOLEAN store_want_symmetry;
           API_BOOLEAN store_want_instances;
           API_BOOLEAN store_want_bookmarks;
           API_BOOLEAN store_want_lights;
           API_BOOLEAN store_want_cameras;
           API_BOOLEAN store_want_shaders;
           API_BOOLEAN store_want_divide_periodic;
           API_BOOLEAN store_want_z_axis;
           API_BOOLEAN store_want_ascii_file;
           int         store_file_version;
           int         store_trim_curve_type;
           API_BOOLEAN store_want_tessellation;
           int         store_tess_type;
           float       store_tess_tolerance;
           API_BOOLEAN store_want_subdivmesh;
	} fbx;

    struct _sat {
           API_BOOLEAN store_want_log;
           API_BOOLEAN store_want_binary;
           int store_version;
    } sat;

    struct _iges_atf {
	   API_BOOLEAN store_want_log;
	   API_BOOLEAN store_want_layer;
	   API_BOOLEAN store_want_group_brep;
	   API_BOOLEAN store_want_group_hierarchy;
	   API_BOOLEAN store_want_curve_asm_conversion;
	   int         store_shell_type;
	   int         store_surface_type;
	   int         store_as_nurbs;
	   float       store_tolerance;
	   float       store_scale;
	   int         store_units;
	   char       *store_file_extension;
    } iges_atf;

    struct _nx_atf {
	   API_BOOLEAN  store_want_log;
	   API_BOOLEAN  store_facets;
	   API_BOOLEAN  store_nurbs;
	   API_BOOLEAN  store_curves;		
	   API_BOOLEAN  store_points;
	   API_BOOLEAN  store_invisibles;
	   API_BOOLEAN  store_templates;
	   API_BOOLEAN  store_keep_topology;
	   API_BOOLEAN  store_layers;
	   API_BOOLEAN  store_empty_layers;
	   API_BOOLEAN  store_categories;
	   API_BOOLEAN  store_empty_categories;
	   API_BOOLEAN  store_layer_symmetry;
	   API_BOOLEAN  store_instances;
	   API_BOOLEAN  store_simplify_primitives;
	   API_BOOLEAN  store_split_periodic;
	   API_BOOLEAN  store_split_g1_breaks;
	   API_BOOLEAN  store_parameterized_planes;
	   API_BOOLEAN  store_want_tessellation;
	   int          store_tessellation_type;
	   float        store_tessellation_tolerance;
	   int          store_file_version;
	   int          store_units;
	   char        *store_cdf_path;
	   API_BOOLEAN  store_convertLayerToCategory;
	   API_BOOLEAN  store_zeroTransform;
    } nx_atf;

    // Only available in OpenAlias:
    struct _ai {
       double      store_width;
       double      store_height;
       double      store_tolerance;
    } ai;

} AlStoreOptions;

#endif
