/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlStatusHandler - augments the status codes of the Alias API
//
//	.SECTION Description
//		There are methods in the Alias API where a standard error code is used
//		in more than one method return statement.  The return value is essentially 
//		overloaded and it becomes difficult for the API developer to figure out which
//		error condition was actually hit.  This class will assist the API
//		developer by providing a text string message whenever the overloaded
//		return value condition is hit. 
//		This class supports retrieving the current status error string and
//		number.  Clearing the state of the status handler and installing
//		and removing callbacks which listen to changes of state in the
//		status handler. 
//
//		Notes:
//		1.  The AlStatusHandler::clear() method is not called automatically
//		by the API.  It is up to the programmer to ensure that the status
//		handler has been cleared.
//		2.  The text messages will only be set in cases where the return
//		value is overloaded.   Therefore it is possible for an API method
//		to fail without any change to the state of the status handler.
//		3.  The Alias API contains many internal checks that could cause
//		a method to return with a failure condition.  In this case, an
//		"internal error" will be returned by the status handler.  This 
//		condition should be rare.
//		4.  The AlStatusHandler::clear() method does not generate a call
//		to a status handler callback.  Therefore it can be used in a status
//		handler callback without running into recursion problems.
//		5.  The overloaded errors handled by this class are sFailure,
//		sInvalidArgument and sInvalidObject.
// 

#ifndef _AlStatusHandler
#define  _AlStatusHandler

#include <AlStyle.h>

class STUDIOAPI_DECL AlStatusHandler
{
	friend class			AlFriend;
public:

	static const char*		statusErrorString();
	static int				statusErrorNumber();
	
	static void 			clear();
 
    static statusCode       installHandler( void (*)(int, const char *) );
    static statusCode       removeHandler( void (*)(int, const char *) );
	
protected:
	static const char*		status_error_string;
	static int 				status_error_number;
	static 					statusCode status;
	static void 			set( statusCode, int ); 
	
};

#endif // _AlStatusHandler
