/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlSpotLight - Encapsulates the creation, deletion and manipulation of a spot light.
//
//	.SECTION Description
//
//		To create a spot light, the user must instantiate and call
//		the create method on an AlSpotLight object.  (For more
//		information on lights in general, see the Class Description
//		of the AlDirectionLight object.)
//
//		The spot light is the only light that uses the 'look at'
//		and 'up' nodes of a light.  The direction vector of a spot
//		light is the vector between the spot light's position point
//		and 'look at' point.  The up direction vector is the vector
//		between the spot light's position point and the 'up' point.
//
//		Other spot light parameters that can be manipulated are
//		spread angle, dropoff, shadows, exclusivity, multiplication
//		factor, offset, size, bias, and penumbra.
//


#ifndef _AlSpotLight
#define _AlSpotLight

#include <AlDirectionLight.h>

class STUDIOAPI_DECL AlSpotLight: public AlDirectionLight {

public:
							AlSpotLight();
	virtual					~AlSpotLight();

	virtual AlObject*		copyWrapper() const;

	statusCode				create();

	AlObjectType			type() const;

	double					dropOff() const;
	double					minBias() const;
	double					maxBias() const;
	double					spreadAngle() const;
	int						offset() const;
	int						multFactor() const;
	int						shadowSize() const;
	double					penumbra() const;

	virtual statusCode		direction( double&, double&, double& ) const;
	virtual statusCode		setDirection( double, double, double );

	statusCode				setDropOff( double );
	statusCode				setMinBias( double );
	statusCode				setMaxBias( double );
	statusCode				setSpreadAngle( double );
	statusCode				setOffset( int );
	statusCode				setMultFactor( int );
	statusCode				setShadowSize( int );
	statusCode				setPenumbra( double);

private:
	// init/fini inherited
};
#endif
