/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlSphereLight - Add parameters for sphere shaped volume light
//
//	.SECTION Description
//
//		A sphere light is a volume light where light exists within a sphere.
//		There are no additional parameters other than those already on
//		the volume light.
//


#ifndef _AlSphereLight
#define _AlSphereLight

#include <AlVolumeLight.h>

class STUDIOAPI_DECL AlSphereLight: public AlVolumeLight
{
public:
							AlSphereLight();
	virtual					~AlSphereLight();

	virtual AlObject*   	copyWrapper() const;

	statusCode				create();

	virtual AlObjectType			type() const;

	double					arc() const;
	statusCode				setArc(double);

private:
	// init/fini inherited
};
#endif
