/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//
//+
//	.NAME AlSpacePoint - Interface to Alias space points.
//
//	.SECTION Description
//		AlSpacePoint is the interface to Alias Space points. A space point can
//		be created at any point in the world coordinate system. There are methods to
//		query and modify the position of the point in this class.

#ifndef __AlSpacePoint
#define __AlSpacePoint


#include <AlPoint.h>

class STUDIOAPI_DECL AlSpacePoint : public AlPoint {
	friend class				AlFriend;

public:

	AlSpacePoint();
	~AlSpacePoint();
	virtual AlObject *	    copyWrapper() const;
	virtual AlObjectType	    type() const;
	statusCode		        create(double x = 0.0, double y = 0.0, double z = 0.0);
	
	statusCode		        setWorldPosition(double x = 0.0, double y = 0.0, double z = 0.0);
	virtual statusCode		worldPosition(double &, double &, double &) const;
};

#endif




















