/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlSnap - Basic Interface to Alias snapping functions
//
//	.SECTION Description
//		This class contains various utility functions for performing
//		snapping. You can snap to grids, CVs and curves.  When using
//		the toGrid function, the world position returned would be
//		used to translate the object to the correct location.  For
//		the CV and curve functions, the world position of the AlObject
//		returned would be used to translate the object to the correct
//		location.  The function snappingTo returns either kSnapGrid,
//		kSnapCurve or kSnapCV based on what buttons have been set in
//		the application.

#ifndef	_AlSnap
#define _AlSnap

#include <AlStyle.h>

enum AlSnapMode {
    kSnapGrid  = 1, /* used if application is snapping to grids */
    kSnapCV    = 2, /* used if application is snapping to CVs */
    kSnapCurve = 4  /* used if application is snapping to curves */
};

class AlWindow;
class AlObject;

class STUDIOAPI_DECL AlSnap {
public:
	static statusCode	toGrid( Screencoord x, Screencoord y, double worldPos[3], AlWindow* window = NULL );
	static statusCode	toCV( Screencoord x, Screencoord y, AlObject* &obj, AlWindow *window = NULL );
	static statusCode	toCurve( Screencoord x, Screencoord y, AlObject* &obj, double &curveParam, AlWindow *window = NULL );
	static int			snappingTo( void );
};

#endif
