/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlShellNode
#define _AlShellNode

//+
//
//	.NAME AlShellNode - Dag node class for shells.
//
//	.SECTION Description
//		This method provides DagNode level access to Shells.  Use the shell
//		method to get the actual AlShell underneath this DagNode.
// .br
//

#include <AlDagNode.h>

class AlShell;

class STUDIOAPI_DECL AlShellNode : public AlDagNode {
	friend 					class AlFriend;
  public:
	virtual					~AlShellNode();

	virtual AlObject		*copyWrapper() const;

	virtual AlObjectType	type() const;

	AlShell*				shell() const;
	AlShell*				shell(AlTM&) const;

protected:
							AlShellNode();
private:
};

#endif
