/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlShell
#define _AlShell

//+
//
//	.NAME AlShell - Interface to Alias nurbs surface geometry.
//
//	.SECTION Description
//		A shell is a collection of surfaces which behave as a single object.
//		Each surface can have its own set of trim curves.   A cube with six
//		square sides is a shell.
//		The cube can be assigned a single shader and rendering formation.
//		The cube is made of a collection of 6 spline surfaces.
//
//		The AlTrimRegions are inaccurately named.
//		They actually represent the surfaces in the shell.
//

#include <AlObject.h>

struct Spline_surface;
struct Dag_node;

struct AlRenderInfo;
class AlTrimRegion;

class STUDIOAPI_DECL AlShell : public AlObject {
	friend class			AlFriend;
public:
							AlShell();
	virtual					~AlShell();
	virtual AlObject*		copyWrapper() const;

	virtual AlObjectType	type() const;
	AlShellNode*			shellNode() const;

	statusCode				create( AlTrimRegion*, API_BOOLEAN );
	statusCode 				addToShell( AlTrimRegion*, API_BOOLEAN );
	API_BOOLEAN					isInShell( AlTrimRegion* );
	AlTrimRegion*			firstTrimRegion() const;

	AlGroupNode*			unstitchShell( void );

	AlShader*				firstShader() const;
	AlShader*				nextShader( const AlShader* ) const;
	AlSwitchShader*			getSwitchShader() const;
    AlLayeredShader*        getLayeredShader() const;
	statusCode				nextShaderD( AlShader* ) const;

	statusCode				assignShader( AlShader* );
	statusCode				layerShader( AlShader* );

	statusCode				renderInfo( AlRenderInfo& ) const;
	statusCode				setRenderInfo( const AlRenderInfo& ) const;

	API_BOOLEAN 				isDisplayModeSet( AlDisplayModeType ) const;
	statusCode 				setDisplayMode( AlDisplayModeType, API_BOOLEAN );

	statusCode 				area( double &, API_BOOLEAN = TRUE, double tolerance=0.001 );
	statusCode 				circumference( double &, API_BOOLEAN = TRUE, double tolerance=0.001 );

protected:
private:
	static void				initMessages();
	static void				finiMessages();
};

#endif
