/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

/*
 *  This file is shared by Alias and OpenModel. Any changes made to
 *  this file must be compatible with both products.
 *
 *	This file contains the enumeration type for shaders
 *	class methods.
 *
 *	This file MUST be compilable under C as well as C++ for the
 *	C interface.  If you add to this file, please make sure C-style
 *	comments are used.
 */

#ifndef ALSHADINGFIELDS_H
#define ALSHADINGFIELDS_H

typedef enum {
	kFLD_SHADING_COMMON_COLOR_R						 = 1,
	kFLD_SHADING_COMMON_COLOR_G						 = 2,
	kFLD_SHADING_COMMON_COLOR_B						 = 3,
	kFLD_SHADING_COMMON_INCANDESCENCE_R				 = 4,
	kFLD_SHADING_COMMON_INCANDESCENCE_G				 = 5,
	kFLD_SHADING_COMMON_INCANDESCENCE_B				 = 6,
	kFLD_SHADING_COMMON_TRANSPARENCY_R				 = 7,
	kFLD_SHADING_COMMON_TRANSPARENCY_G				 = 8,
	kFLD_SHADING_COMMON_TRANSPARENCY_B				 = 9,
	kFLD_SHADING_COMMON_USE_BACKGROUND_COLOR		 = 10,
	kFLD_SHADING_COMMON_REFRACTIVE_INDEX			 = 11,
	kFLD_SHADING_COMMON_REFLECTION_LIMIT			 = 12,
	kFLD_SHADING_COMMON_REFRACTION_LIMIT			 = 13,
	kFLD_SHADING_COMMON_SHADOW_LEVEL_LIMIT			 = 14,
	kFLD_SHADING_COMMON_TRANSPARENCY_SHADE			 = 15,
	kFLD_SHADING_COMMON_RESPECT_REFLECTION_MAP		 = 16,

	kFLD_SHADING_LAMBERT_DIFFUSE					 = 18,

	kFLD_SHADING_PHONG_DIFFUSE						 = 20,
	kFLD_SHADING_PHONG_SPECULAR_R					 = 21,
	kFLD_SHADING_PHONG_SPECULAR_G					 = 22,
	kFLD_SHADING_PHONG_SPECULAR_B					 = 23,
	kFLD_SHADING_PHONG_SHINYNESS					 = 24,
	kFLD_SHADING_PHONG_REFLECTIVITY					 = 25,

	kFLD_SHADING_BLINN_DIFFUSE						 = 27,
	kFLD_SHADING_BLINN_SPECULAR_R					 = 28,
	kFLD_SHADING_BLINN_SPECULAR_G					 = 29,
	kFLD_SHADING_BLINN_SPECULAR_B					 = 30,
	kFLD_SHADING_BLINN_SPECULAR_ROLLOFF				 = 31,
	kFLD_SHADING_BLINN_ECCENTRICITY					 = 32,
	kFLD_SHADING_BLINN_REFLECTIVITY					 = 33,

	kFLD_SHADING_BACKGROUND_COLOR_R					 = 35,
	kFLD_SHADING_BACKGROUND_COLOR_G					 = 36,
	kFLD_SHADING_BACKGROUND_COLOR_B					 = 37,

	kFLD_SHADING_FOG_COLOR_R						 = 39,
	kFLD_SHADING_FOG_COLOR_G						 = 40,
	kFLD_SHADING_FOG_COLOR_B						 = 41,
	kFLD_SHADING_FOG_DEPTH_R						 = 42,
	kFLD_SHADING_FOG_DEPTH_G						 = 43,
	kFLD_SHADING_FOG_DEPTH_B						 = 44,
	kFLD_SHADING_FOG_MIN_ALTITUDE					 = 45,
	kFLD_SHADING_FOG_MAX_ALTITUDE					 = 46,
	kFLD_SHADING_FOG_AMULT							 = 47,
	kFLD_SHADING_FOG_AOFFSET						 = 48,
	kFLD_SHADING_FOG_FOGTYPE						 = 49,
	kFLD_SHADING_FOG_COLUMN							 = 50,

	kFLD_SHADING_TEXTURE_ACTIVE						 = 52,

	kFLD_SHADING_COMMON_TEXTURE_RGBMULT_R			 = 54,
	kFLD_SHADING_COMMON_TEXTURE_RGBMULT_G			 = 55,
	kFLD_SHADING_COMMON_TEXTURE_RGBMULT_B			 = 56,
	kFLD_SHADING_COMMON_TEXTURE_RGBOFFSET_R			 = 57,
	kFLD_SHADING_COMMON_TEXTURE_RGBOFFSET_G			 = 58,
	kFLD_SHADING_COMMON_TEXTURE_RGBOFFSET_B			 = 59,
	kFLD_SHADING_COMMON_TEXTURE_AMULT				 = 60,
	kFLD_SHADING_COMMON_TEXTURE_AOFFSET				 = 61,
	kFLD_SHADING_COMMON_TEXTURE_BLURMULT			 = 62,
	kFLD_SHADING_COMMON_TEXTURE_BLUROFFSET			 = 63,
	kFLD_SHADING_COMMON_TEXTURE_ROTATE				 = 64,
	kFLD_SHADING_COMMON_TEXTURE_UREPEAT				 = 65,
	kFLD_SHADING_COMMON_TEXTURE_VREPEAT				 = 66,
	kFLD_SHADING_COMMON_TEXTURE_UOFFSET				 = 67,
	kFLD_SHADING_COMMON_TEXTURE_VOFFSET				 = 68,
	kFLD_SHADING_COMMON_TEXTURE_MIRROR				 = 69,
	kFLD_SHADING_COMMON_TEXTURE_UNUSED				 = 70,
	kFLD_SHADING_COMMON_TEXTURE_UCOVERAGE			 = 71,
	kFLD_SHADING_COMMON_TEXTURE_VCOVERAGE			 = 72,
	kFLD_SHADING_COMMON_TEXTURE_UTRANSLATE			 = 73,
	kFLD_SHADING_COMMON_TEXTURE_VTRANSLATE			 = 74,
	kFLD_SHADING_COMMON_TEXTURE_UWRAP				 = 75,
	kFLD_SHADING_COMMON_TEXTURE_VWRAP				 = 76,

	kFLD_SHADING_BULGE_UWIDTH						 = 78,
	kFLD_SHADING_BULGE_VWIDTH						 = 79,

	kFLD_SHADING_BALL_INCLINATION					 = 81,
	kFLD_SHADING_BALL_ELEVATION						 = 82,
	kFLD_SHADING_BALL_EYESPACE						 = 83,
	kFLD_SHADING_BALL_REFLECT						 = 84,
	kFLD_SHADING_BALL_SKY_RADIUS					 = 85,
	kFLD_SHADING_BALL_BOTTOM						 = 86,
	kFLD_SHADING_BALL_TOP							 = 87,
	kFLD_SHADING_BALL_LEFT							 = 88,
	kFLD_SHADING_BALL_RIGHT							 = 89,
	kFLD_SHADING_BALL_FRONT							 = 90,
	kFLD_SHADING_BALL_BACK							 = 91,

	kFLD_SHADING_CHECKER_COLOR1_R					 = 93,
	kFLD_SHADING_CHECKER_COLOR1_G					 = 94,
	kFLD_SHADING_CHECKER_COLOR1_B					 = 95,
	kFLD_SHADING_CHECKER_COLOR2_R					 = 96,
	kFLD_SHADING_CHECKER_COLOR2_G					 = 97,
	kFLD_SHADING_CHECKER_COLOR2_B					 = 98,
	kFLD_SHADING_CHECKER_CONTRAST					 = 99,

	kFLD_SHADING_CLOTH_U_THREAD_COLOR_R				 = 101,
	kFLD_SHADING_CLOTH_U_THREAD_COLOR_G				 = 102,
	kFLD_SHADING_CLOTH_U_THREAD_COLOR_B				 = 103,
	kFLD_SHADING_CLOTH_V_THREAD_COLOR_R				 = 104,
	kFLD_SHADING_CLOTH_V_THREAD_COLOR_G				 = 105,
	kFLD_SHADING_CLOTH_V_THREAD_COLOR_B				 = 106,
	kFLD_SHADING_CLOTH_GAP_COLOR_R					 = 107,
	kFLD_SHADING_CLOTH_GAP_COLOR_G					 = 108,
	kFLD_SHADING_CLOTH_GAP_COLOR_B					 = 109,
	kFLD_SHADING_CLOTH_U_THREAD_WIDTH				 = 110,
	kFLD_SHADING_CLOTH_V_THREAD_WIDTH				 = 111,
	kFLD_SHADING_CLOTH_U_WAVE						 = 112,
	kFLD_SHADING_CLOTH_V_WAVE						 = 113,
	kFLD_SHADING_CLOTH_RANDOMNESS					 = 114,
	kFLD_SHADING_CLOTH_WIDTH_SPREAD					 = 115,
	kFLD_SHADING_CLOTH_BRIGHTNESS_SPREAD			 = 116,

	kFLD_SHADING_CHROME_SKY_COLOR_R					 = 118,
	kFLD_SHADING_CHROME_SKY_COLOR_G					 = 119,
	kFLD_SHADING_CHROME_SKY_COLOR_B					 = 120,
	kFLD_SHADING_CHROME_ZENITH_COLOR_R				 = 121,
	kFLD_SHADING_CHROME_ZENITH_COLOR_G				 = 122,
	kFLD_SHADING_CHROME_ZENITH_COLOR_B				 = 123,
	kFLD_SHADING_CHROME_LIGHT_COLOR_R				 = 124,
	kFLD_SHADING_CHROME_LIGHT_COLOR_G				 = 125,
	kFLD_SHADING_CHROME_LIGHT_COLOR_B				 = 126,
	kFLD_SHADING_CHROME_LIGHT_WIDTH					 = 127,
	kFLD_SHADING_CHROME_LIGHT_WIDTH_MULT			 = 128,
	kFLD_SHADING_CHROME_LIGHT_WIDTH_OFFSET			 = 129,
	kFLD_SHADING_CHROME_LIGHT_DEPTH					 = 130,
	kFLD_SHADING_CHROME_LIGHT_DEPTH_MULT			 = 131,
	kFLD_SHADING_CHROME_LIGHT_DEPTH_OFFSET			 = 132,
	kFLD_SHADING_CHROME_FLOOR_COLOR_R				 = 133,
	kFLD_SHADING_CHROME_FLOOR_COLOR_G				 = 134,
	kFLD_SHADING_CHROME_FLOOR_COLOR_B				 = 135,
	kFLD_SHADING_CHROME_HORIZON_COLOR_R				 = 136,
	kFLD_SHADING_CHROME_HORIZON_COLOR_G				 = 137,
	kFLD_SHADING_CHROME_HORIZON_COLOR_B				 = 138,
	kFLD_SHADING_CHROME_GRID_COLOR_R				 = 139,
	kFLD_SHADING_CHROME_GRID_COLOR_G				 = 140,
	kFLD_SHADING_CHROME_GRID_COLOR_B				 = 141,
	kFLD_SHADING_CHROME_REAL_FLOOR					 = 142,
	kFLD_SHADING_CHROME_GRID_WIDTH					 = 143,
	kFLD_SHADING_CHROME_GRID_WIDTH_MULT				 = 144,
	kFLD_SHADING_CHROME_GRID_WIDTH_OFFSET			 = 145,
	kFLD_SHADING_CHROME_GRID_DEPTH					 = 146,
	kFLD_SHADING_CHROME_GRID_DEPTH_MULT				 = 147,
	kFLD_SHADING_CHROME_GRID_DEPTH_OFFSET			 = 148,

	kFLD_SHADING_CURVATURE_MIN						 = 151,
	kFLD_SHADING_CURVATURE_MAX						 = 152,

	kFLD_SHADING_FRACTAL_AMPLITUDE					 = 155,
	kFLD_SHADING_FRACTAL_THRESHOLD					 = 156,
	kFLD_SHADING_FRACTAL_RATIO						 = 157,
	kFLD_SHADING_FRACTAL_LEVEL_MIN					 = 158,
	kFLD_SHADING_FRACTAL_LEVEL_MAX					 = 159,
	kFLD_SHADING_FRACTAL_ANIMATED					 = 160,
	kFLD_SHADING_FRACTAL_TIME						 = 161,

	kFLD_SHADING_GRID_LINE_COLOR_R					 = 163,
	kFLD_SHADING_GRID_LINE_COLOR_G					 = 164,
	kFLD_SHADING_GRID_LINE_COLOR_B					 = 165,
	kFLD_SHADING_GRID_FILLER_COLOR_R				 = 166,
	kFLD_SHADING_GRID_FILLER_COLOR_G				 = 167,
	kFLD_SHADING_GRID_FILLER_COLOR_B				 = 168,
	kFLD_SHADING_GRID_UWIDTH						 = 169,
	kFLD_SHADING_GRID_VWIDTH						 = 170,
	kFLD_SHADING_GRID_CONTRAST						 = 171,

	kFLD_SHADING_HIGHLIGHT_MIN						 = 173,
	kFLD_SHADING_HIGHLIGHT_MAX						 = 174,
	kFLD_SHADING_HIGHLIGHT_HLDIRECTION_X			 = 175,
	kFLD_SHADING_HIGHLIGHT_HLDIRECTION_Y			 = 176,
	kFLD_SHADING_HIGHLIGHT_HLDIRECTION_Z			 = 177,

	kFLD_SHADING_MOUNTAIN_SNOW_COLOR_R				 = 179,
	kFLD_SHADING_MOUNTAIN_SNOW_COLOR_G				 = 180,
	kFLD_SHADING_MOUNTAIN_SNOW_COLOR_B				 = 181,
	kFLD_SHADING_MOUNTAIN_ROCK_COLOR_R				 = 182,
	kFLD_SHADING_MOUNTAIN_ROCK_COLOR_G				 = 183,
	kFLD_SHADING_MOUNTAIN_ROCK_COLOR_B				 = 184,
	kFLD_SHADING_MOUNTAIN_AMPLITUDE					 = 185,
	kFLD_SHADING_MOUNTAIN_SNOW_ROUGHNESS			 = 186,
	kFLD_SHADING_MOUNTAIN_ROCK_ROUGHNESS			 = 187,
	kFLD_SHADING_MOUNTAIN_BOUNDARY_ROUGHNESS		 = 188,
	kFLD_SHADING_MOUNTAIN_SNOW_ALTITUDE				 = 189,
	kFLD_SHADING_MOUNTAIN_SNOW_DROPOFF				 = 190,
	kFLD_SHADING_MOUNTAIN_SNOW_MAX_SLOPE			 = 191,
	kFLD_SHADING_MOUNTAIN_LEVEL_MAX					 = 192,


	kFLD_SHADING_NOISE_AMPLITUDE					 = 194,
	kFLD_SHADING_NOISE_THRESHOLD					 = 195,
	kFLD_SHADING_NOISE_ANIMATED						 = 196,
	kFLD_SHADING_NOISE_TIME							 = 197,

	kFLD_SHADING_RAMP_U_WAVE						 = 199,
	kFLD_SHADING_RAMP_V_WAVE						 = 200,
	kFLD_SHADING_RAMP_NOISE							 = 201,
	kFLD_SHADING_RAMP_NOISE_FREQUENCY				 = 202,
	kFLD_SHADING_RAMP_HUE_NOISE						 = 203,
	kFLD_SHADING_RAMP_SAT_NOISE						 = 204,
	kFLD_SHADING_RAMP_VAL_NOISE						 = 205,
	kFLD_SHADING_RAMP_HUE_NOISE_FREQUENCY			 = 206,
	kFLD_SHADING_RAMP_SAT_NOISE_FREQUENCY			 = 207,
	kFLD_SHADING_RAMP_VAL_NOISE_FREQUENCY			 = 208,

	kFLD_SHADING_SCLOUD_COLOR1_R					 = 217,
	kFLD_SHADING_SCLOUD_COLOR1_G					 = 218,
	kFLD_SHADING_SCLOUD_COLOR1_B					 = 219,
	kFLD_SHADING_SCLOUD_COLOR2_R					 = 220,
	kFLD_SHADING_SCLOUD_COLOR2_G					 = 221,
	kFLD_SHADING_SCLOUD_COLOR2_B					 = 222,
	kFLD_SHADING_SCLOUD_CONTRAST					 = 223,
	kFLD_SHADING_SCLOUD_SOFT_EDGES					 = 224,
	kFLD_SHADING_SCLOUD_TRANSPARENCY_RANGE			 = 225,
	kFLD_SHADING_SCLOUD_CENTER_THRESHOLD			 = 226,
	kFLD_SHADING_SCLOUD_EDGE_THRESHOLD				 = 227,
	kFLD_SHADING_SCLOUD_AMPLITUDE					 = 228,
	kFLD_SHADING_SCLOUD_RATIO						 = 229,
	kFLD_SHADING_SCLOUD_LEVEL_MIN					 = 230,
	kFLD_SHADING_SCLOUD_LEVEL_MAX					 = 231,
	kFLD_SHADING_SCLOUD_XRIPPLES					 = 232,
	kFLD_SHADING_SCLOUD_YRIPPLES					 = 233,
	kFLD_SHADING_SCLOUD_ZRIPPLES					 = 234,

	kFLD_SHADING_SFRACTAL_THRESHOLD					 = 236,
	kFLD_SHADING_SFRACTAL_AMPLITUDE					 = 237,
	kFLD_SHADING_SFRACTAL_RATIO						 = 238,
	kFLD_SHADING_SFRACTAL_LEVEL_MIN					 = 239,
	kFLD_SHADING_SFRACTAL_LEVEL_MAX					 = 240,
	kFLD_SHADING_SFRACTAL_XRIPPLES					 = 241,
	kFLD_SHADING_SFRACTAL_YRIPPLES					 = 242,
	kFLD_SHADING_SFRACTAL_ZRIPPLES					 = 243,

	kFLD_SHADING_SKY_TOTAL_BRIGHTNESS				 = 245,
	kFLD_SHADING_SKY_SUN_BRIGHTNESS_R				 = 246,
	kFLD_SHADING_SKY_SUN_BRIGHTNESS_G				 = 247,
	kFLD_SHADING_SKY_SUN_BRIGHTNESS_B				 = 248,
	kFLD_SHADING_SKY_SUN_HALO_BRIGHTNESS_R			 = 249,
	kFLD_SHADING_SKY_SUN_HALO_BRIGHTNESS_G			 = 250,
	kFLD_SHADING_SKY_SUN_HALO_BRIGHTNESS_B			 = 251,
	kFLD_SHADING_SKY_SUN_ELEVATION					 = 252,
	kFLD_SHADING_SKY_SUN_AZIMUTH					 = 253,
	kFLD_SHADING_SKY_SUN_SIZE						 = 254,
	kFLD_SHADING_SKY_SUN_BLUR						 = 255,
	kFLD_SHADING_SKY_SKY_BRIGHTNESS_R				 = 256,
	kFLD_SHADING_SKY_SKY_BRIGHTNESS_G				 = 257,
	kFLD_SHADING_SKY_SKY_BRIGHTNESS_B				 = 258,
	kFLD_SHADING_SKY_AIR_DENSITY					 = 259,
	kFLD_SHADING_SKY_DUST_DENSITY					 = 260,
	kFLD_SHADING_SKY_SKY_THICKNESS					 = 261,
	kFLD_SHADING_SKY_SKY_RADIUS						 = 262,
	kFLD_SHADING_SKY_HAS_FLOOR						 = 263,
	kFLD_SHADING_SKY_FLOOR_TEXTURE_R				 = 264,
	kFLD_SHADING_SKY_FLOOR_TEXTURE_G				 = 265,
	kFLD_SHADING_SKY_FLOOR_TEXTURE_B				 = 266,
	kFLD_SHADING_SKY_CLOUD_BRIGHTNESS_R				 = 267,
	kFLD_SHADING_SKY_CLOUD_BRIGHTNESS_G				 = 268,
	kFLD_SHADING_SKY_CLOUD_BRIGHTNESS_B				 = 269,
	kFLD_SHADING_SKY_SUNSET_BRIGHTNESS_R			 = 270,
	kFLD_SHADING_SKY_SUNSET_BRIGHTNESS_G			 = 271,
	kFLD_SHADING_SKY_SUNSET_BRIGHTNESS_B			 = 272,
	kFLD_SHADING_SKY_CLOUD_DENSITY					 = 273,
	kFLD_SHADING_SKY_CLOUD_THRESHOLD				 = 274,
	kFLD_SHADING_SKY_CLOUD_POWER					 = 275,
	kFLD_SHADING_SKY_CLOUD_ALTITUDE					 = 276,
	kFLD_SHADING_SKY_CLOUD_HALO_SIZE				 = 277,
	kFLD_SHADING_SKY_SKY_SAMPLES					 = 278,
	kFLD_SHADING_SKY_FLOOR_SAMPLES					 = 279,
	kFLD_SHADING_SKY_CLOUD_SAMPLES					 = 280,

	kFLD_SHADING_STENCIL_EDGE_BLEND					 = 282,
	kFLD_SHADING_STENCIL_MASK_LEVEL					 = 283,
	kFLD_SHADING_STENCIL_MASK_BLUR					 = 284,
	kFLD_SHADING_STENCIL_KEY_MASKING				 = 285,
	kFLD_SHADING_STENCIL_POSITIVE_KEY				 = 286,
	kFLD_SHADING_STENCIL_COLOR_KEY_R				 = 287,
	kFLD_SHADING_STENCIL_COLOR_KEY_G				 = 288,
	kFLD_SHADING_STENCIL_COLOR_KEY_B				 = 289,
	kFLD_SHADING_STENCIL_HUE_RANGE					 = 290,
	kFLD_SHADING_STENCIL_SAT_RANGE					 = 291,
	kFLD_SHADING_STENCIL_VAL_RANGE					 = 292,
	kFLD_SHADING_STENCIL_THRESHOLD					 = 293,

	kFLD_SHADING_SFILE_XAMPLITUDE					 = 301,
	kFLD_SHADING_SFILE_YAMPLITUDE					 = 302,
	kFLD_SHADING_SFILE_RATIO						 = 303,
	kFLD_SHADING_SFILE_LEVEL_MIN					 = 304,
	kFLD_SHADING_SFILE_LEVEL_MAX					 = 305,
	kFLD_SHADING_SFILE_XRIPPLES						 = 306,
	kFLD_SHADING_SFILE_YRIPPLES						 = 307,
	kFLD_SHADING_SFILE_ZRIPPLES						 = 308,

	kFLD_SHADING_SMARBLE_FILLER_COLOR_R				 = 310,
	kFLD_SHADING_SMARBLE_FILLER_COLOR_G				 = 311,
	kFLD_SHADING_SMARBLE_FILLER_COLOR_B				 = 312,
	kFLD_SHADING_SMARBLE_VEIN_COLOR_R				 = 313,
	kFLD_SHADING_SMARBLE_VEIN_COLOR_G				 = 314,
	kFLD_SHADING_SMARBLE_VEIN_COLOR_B				 = 315,
	kFLD_SHADING_SMARBLE_VEIN_WIDTH					 = 316,
	kFLD_SHADING_SMARBLE_DIFFUSION					 = 317,
	kFLD_SHADING_SMARBLE_CONTRAST					 = 318,
	kFLD_SHADING_SMARBLE_AMPLITUDE					 = 319,
	kFLD_SHADING_SMARBLE_RATIO						 = 320,
	kFLD_SHADING_SMARBLE_LEVEL_MIN					 = 321,
	kFLD_SHADING_SMARBLE_LEVEL_MAX					 = 322,
	kFLD_SHADING_SMARBLE_XRIPPLES					 = 323,
	kFLD_SHADING_SMARBLE_YRIPPLES					 = 324,
	kFLD_SHADING_SMARBLE_ZRIPPLES					 = 325,

	kFLD_SHADING_SNOW_COLOR_R						 = 327,
	kFLD_SHADING_SNOW_COLOR_G						 = 328,
	kFLD_SHADING_SNOW_COLOR_B						 = 329,
	kFLD_SHADING_SNOW_SURFACE_COLOR_R				 = 330,
	kFLD_SHADING_SNOW_SURFACE_COLOR_G				 = 331,
	kFLD_SHADING_SNOW_SURFACE_COLOR_B				 = 332,
	kFLD_SHADING_SNOW_THRESHOLD						 = 333,
	kFLD_SHADING_SNOW_DEPTH_DECAY					 = 334,
	kFLD_SHADING_SNOW_THICKNESS						 = 335,


	kFLD_SHADING_SPHERE_SHEAR_U						 = 337,
	kFLD_SHADING_SPHERE_SHEAR_V						 = 338,
	kFLD_SHADING_SPHERE_FLIP						 = 339,

	kFLD_SHADING_SROCK_COLOR1_R						 = 341,
	kFLD_SHADING_SROCK_COLOR1_G						 = 342,
	kFLD_SHADING_SROCK_COLOR1_B						 = 343,
	kFLD_SHADING_SROCK_COLOR2_R						 = 344,
	kFLD_SHADING_SROCK_COLOR2_G						 = 345,
	kFLD_SHADING_SROCK_COLOR2_B						 = 346,
	kFLD_SHADING_SROCK_GRAIN_SIZE					 = 347,
	kFLD_SHADING_SROCK_DIFFUSION					 = 348,
	kFLD_SHADING_SROCK_MIX_RATIO					 = 349,

	kFLD_SHADING_LEATHER_CELL_COLOR_R				 = 351,
	kFLD_SHADING_LEATHER_CELL_COLOR_G				 = 352,
	kFLD_SHADING_LEATHER_CELL_COLOR_B				 = 353,
	kFLD_SHADING_LEATHER_CREASE_COLOR_R				 = 354,
	kFLD_SHADING_LEATHER_CREASE_COLOR_G				 = 355,
	kFLD_SHADING_LEATHER_CREASE_COLOR_B				 = 356,
	kFLD_SHADING_LEATHER_CELL_SIZE					 = 357,
	kFLD_SHADING_LEATHER_DENSITY					 = 358,
	kFLD_SHADING_LEATHER_SPOTTYNESS					 = 359,
	kFLD_SHADING_LEATHER_RANDOMNESS					 = 360,
	kFLD_SHADING_LEATHER_THRESHOLD					 = 361,
	kFLD_SHADING_LEATHER_CREASES					 = 362,


	kFLD_SHADING_GRANITE_COLOR1_R					 = 364,
	kFLD_SHADING_GRANITE_COLOR1_G					 = 365,
	kFLD_SHADING_GRANITE_COLOR1_B					 = 366,
	kFLD_SHADING_GRANITE_COLOR2_R					 = 367,
	kFLD_SHADING_GRANITE_COLOR2_G					 = 368,
	kFLD_SHADING_GRANITE_COLOR2_B					 = 369,
	kFLD_SHADING_GRANITE_COLOR3_R					 = 370,
	kFLD_SHADING_GRANITE_COLOR3_G					 = 371,
	kFLD_SHADING_GRANITE_COLOR3_B					 = 372,
	kFLD_SHADING_GRANITE_FILLER_COLOR_R				 = 373,
	kFLD_SHADING_GRANITE_FILLER_COLOR_G				 = 374,
	kFLD_SHADING_GRANITE_FILLER_COLOR_B				 = 375,
	kFLD_SHADING_GRANITE_CELL_SIZE					 = 376,
	kFLD_SHADING_GRANITE_DENSITY					 = 377,
	kFLD_SHADING_GRANITE_MIX_RATIO					 = 378,
	kFLD_SHADING_GRANITE_SPOTTYNESS					 = 379,
	kFLD_SHADING_GRANITE_RANDOMNESS					 = 380,
	kFLD_SHADING_GRANITE_THRESHOLD					 = 381,
	kFLD_SHADING_GRANITE_CREASES					 = 382,

	kFLD_SHADING_SWOOD_FILLER_COLOR_R				 = 384,
	kFLD_SHADING_SWOOD_FILLER_COLOR_G				 = 385,
	kFLD_SHADING_SWOOD_FILLER_COLOR_B				 = 386,
	kFLD_SHADING_SWOOD_VEIN_COLOR_R					 = 387,
	kFLD_SHADING_SWOOD_VEIN_COLOR_G					 = 388,
	kFLD_SHADING_SWOOD_VEIN_COLOR_B					 = 389,
	kFLD_SHADING_SWOOD_VEIN_SPREAD					 = 390,
	kFLD_SHADING_SWOOD_LAYER_SIZE					 = 391,
	kFLD_SHADING_SWOOD_RANDOMNESS					 = 392,
	kFLD_SHADING_SWOOD_AGE							 = 393,
	kFLD_SHADING_SWOOD_GRAIN_COLOR_R				 = 394,
	kFLD_SHADING_SWOOD_GRAIN_COLOR_G				 = 395,
	kFLD_SHADING_SWOOD_GRAIN_COLOR_B				 = 396,
	kFLD_SHADING_SWOOD_GRAIN_CONTRAST				 = 397,
	kFLD_SHADING_SWOOD_GRAIN_SPACING				 = 398,
	kFLD_SHADING_SWOOD_CENTER_U						 = 399,
	kFLD_SHADING_SWOOD_CENTER_V						 = 400,
	kFLD_SHADING_SWOOD_XAMPLITUDE					 = 401,
	kFLD_SHADING_SWOOD_YAMPLITUDE					 = 402,
	kFLD_SHADING_SWOOD_RATIO						 = 403,
	kFLD_SHADING_SWOOD_LEVEL_MIN					 = 404,
	kFLD_SHADING_SWOOD_LEVEL_MAX					 = 405,
	kFLD_SHADING_SWOOD_XRIPPLES						 = 406,
	kFLD_SHADING_SWOOD_YRIPPLES						 = 407,
	kFLD_SHADING_SWOOD_ZRIPPLES						 = 408,

	kFLD_SHADING_VOLUME_FROM						 = 410,
	kFLD_SHADING_VOLUME_TO							 = 411,

	kFLD_SHADING_WATER_NUMWAVES						 = 413,
	kFLD_SHADING_WATER_WAVE_TIME					 = 414,
	kFLD_SHADING_WATER_WAVE_VELOCITY				 = 415,
	kFLD_SHADING_WATER_WAVE_AMPLITUDE				 = 416,
	kFLD_SHADING_WATER_FREQUENCY					 = 417,
	kFLD_SHADING_WATER_SUB_FREQUENCY				 = 418,
	kFLD_SHADING_WATER_SMOOTHNESS					 = 419,
	kFLD_SHADING_WATER_WIND_U						 = 420,
	kFLD_SHADING_WATER_WIND_V						 = 421,
	kFLD_SHADING_WATER_RIPPLE_TIME					 = 422,
	kFLD_SHADING_WATER_RIPPLE_FREQUENCY				 = 423,
	kFLD_SHADING_WATER_RIPPLE_AMPLITUDE				 = 424,
	kFLD_SHADING_WATER_RIPPLE_DROP_SIZE				 = 425,
	kFLD_SHADING_WATER_RIPPLE_U_ORIGIN				 = 426,
	kFLD_SHADING_WATER_RIPPLE_V_ORIGIN				 = 427,
	kFLD_SHADING_WATER_RIPPLE_GROUP_VELOCITY		 = 428,
	kFLD_SHADING_WATER_RIPPLE_PHASE_VELOCITY		 = 429,
	kFLD_SHADING_WATER_RIPPLE_SPREAD_START			 = 430,
	kFLD_SHADING_WATER_RIPPLE_SPREAD_RATE			 = 431,
	kFLD_SHADING_WATER_REFLECTION_BOUNDARY			 = 432,
	kFLD_SHADING_WATER_UMIN							 = 433,
	kFLD_SHADING_WATER_UMAX							 = 434,
	kFLD_SHADING_WATER_VMIN							 = 435,
	kFLD_SHADING_WATER_VMAX							 = 436,



/* V5.0 ids  */
	kFLD_SHADING_COMMON_GLOW_INTENSITY               = 437,
	kFLD_SHADING_COMMON_HIDE_GLOW_SOURCE             = 438,
	kFLD_SHADING_COMMON_SURFACE_WIDTH                = 439,
	kFLD_SHADING_COMMON_TRANSPARENCY_DEPTH           = 440,
	kFLD_SHADING_COMMON_CHROMATIC_ABBERATION         = 441,
	kFLD_SHADING_COMMON_REFRACTION_JITTER	         = 442,
	kFLD_SHADING_COMMON_REFRACTION_SAMPLES	         = 443,
	kFLD_SHADING_COMMON_USE_FILL_COLOR				 = 444,
	kFLD_SHADING_COMMON_FILL_COLOR_R		         = 445,
	kFLD_SHADING_COMMON_FILL_COLOR_G		         = 446,
	kFLD_SHADING_COMMON_FILL_COLOR_B		         = 447,
	kFLD_SHADING_COMMON_LINE_THICKNESS   	         = 448,
	kFLD_SHADING_COMMON_U_PATCH_LINES   	         = 449,
	kFLD_SHADING_COMMON_V_PATCH_LINES   	         = 450,
	kFLD_SHADING_FOG_ACTIVE				   	         = 451,
	kFLD_SHADING_COMMON_TEXTURE_STAGGER              = 452,
	kFLD_SHADING_COMMON_TEXTURE_NOT_USED	         = 453,
	kFLD_SHADING_COMMON_TEXTURE_INVERT     		     = 454,
	kFLD_SHADING_COMMON_TEXTURE_CHORD_LENGTH         = 455,
	kFLD_SHADING_COMMON_TEXTURE_WRAP		         = 456,
	kFLD_SHADING_COMMON_TEXTURE_BLEND		         = 457,
	kFLD_SHADING_RAMP_TYPE		  			         = 458,
	kFLD_SHADING_RAMP_INTERPOLATION		             = 459,
	kFLD_SHADING_HIGHLIGHT_REPEATS			 		 = 460,
	kFLD_SHADING_FILE_USE_EXTENSION			 		 = 461,
	kFLD_SHADING_FILE_FRAME_EXTENSION		 		 = 462,
	kFLD_SHADING_SFILE_PROJECTION			 		 = 463,
	kFLD_SHADING_SFILE_STAGGER						 = 464,
	kFLD_SHADING_CURVATURE_REPEATS			 		 = 465,
	kFLD_SHADING_SHADERGLOW_GLOW_TYPE		 		 = 466,
	kFLD_SHADING_SHADERGLOW_HALO_TYPE		 		 = 467,
	kFLD_SHADING_SHADERGLOW_QUALITY	   		 		 = 468,
	kFLD_SHADING_SHADERGLOW_THRESHOLD		 		 = 469,
	kFLD_SHADING_SHADERGLOW_GLOW_COLOR_R	 		 = 470,
	kFLD_SHADING_SHADERGLOW_GLOW_COLOR_G	 		 = 471,
	kFLD_SHADING_SHADERGLOW_GLOW_COLOR_B	 		 = 472,
	kFLD_SHADING_SHADERGLOW_GLOW_INTENSITY	 		 = 473,
	kFLD_SHADING_SHADERGLOW_GLOW_SPREAD		 		 = 474,
	kFLD_SHADING_SHADERGLOW_GLOW_ECCENTRICITY		 = 475,
	kFLD_SHADING_SHADERGLOW_GLOW_RADIAL_NOISE		 = 476,
	kFLD_SHADING_SHADERGLOW_GLOW_STAR_LEVEL		 	 = 477,
	kFLD_SHADING_SHADERGLOW_GLOW_OPACITY		 	 = 478,
	kFLD_SHADING_SHADERGLOW_HALO_COLOR_R	 		 = 479,
	kFLD_SHADING_SHADERGLOW_HALO_COLOR_G	 		 = 480,
	kFLD_SHADING_SHADERGLOW_HALO_COLOR_B	 		 = 481,
	kFLD_SHADING_SHADERGLOW_HALO_SPREAD		 		 = 482,
	kFLD_SHADING_SHADERGLOW_HALO_ECCENTRICITY		 = 483,
	kFLD_SHADING_SHADERGLOW_HALO_RADIAL_NOISE		 = 484,
	kFLD_SHADING_SHADERGLOW_HALO_STAR_LEVEL		 	 = 485,
	kFLD_SHADING_SHADERGLOW_HALO_LENS_FLARE		 	 = 486,
	kFLD_SHADING_SHADERGLOW_ROTATION		 		 = 487,
	kFLD_SHADING_SHADERGLOW_RADIAL_NOISE_FREQUENCY	 = 488,
	kFLD_SHADING_SHADERGLOW_STAR_POINTS		 		 = 489,
	kFLD_SHADING_LENSEFFECT_FILM_GRAIN		 		 = 490,
	kFLD_SHADING_LENSEFFECT_FILTER_R		 		 = 491,
	kFLD_SHADING_LENSEFFECT_FILTER_G		 		 = 492,
	kFLD_SHADING_LENSEFFECT_FILTER_B		 		 = 493,
	kFLD_SHADING_MASTERLIGHT_INTENSITY		 		 = 494,
	kFLD_SHADING_MASTERLIGHT_COLOR_R		 		 = 495,
	kFLD_SHADING_MASTERLIGHT_COLOR_G		 		 = 496,
	kFLD_SHADING_MASTERLIGHT_COLOR_B		 		 = 497,

	kFLD_SHADING_COMMON_TRANSLUCENCE		 		 = 498,
	kFLD_SHADING_COMMON_TRANSLUCENCE_DEPTH	 		 = 499,
	kFLD_SHADING_COMMON_OPACITY_DEPTH	 		     = 500,

	/*
	// Particle systems are encrypted, and these block defines
	// are used within isFieldAllowed to check for the particle
	// system ranges.  Please keep these constants up to date
	*/

#define kFLD_SHADING_PSYS_START_BLOCK				501

	kFLD_SHADING_COMMON_PSYS_EMISSION	 		     = 501,
	kFLD_SHADING_COMMON_PSYS_RENDER_TYPE	 		 = 502,
	kFLD_SHADING_COMMON_PSYS_MOTION_TYPE	 		 = 503,
	kFLD_SHADING_COMMON_PSYS_GLOW_INTENSITY	 		 = 504,
	kFLD_SHADING_COMMON_PSYS_PARENT_SHADING	 		 = 505,
	kFLD_SHADING_COMMON_PSYS_COLOR_R		     	 = 506,
	kFLD_SHADING_COMMON_PSYS_COLOR_G	 	     	 = 507,
	kFLD_SHADING_COMMON_PSYS_COLOR_B	 	     	 = 508,
	kFLD_SHADING_COMMON_PSYS_INCANDESCENCE_R	   	 = 509,
	kFLD_SHADING_COMMON_PSYS_INCANDESCENCE_G	   	 = 510,
	kFLD_SHADING_COMMON_PSYS_INCANDESCENCE_B	   	 = 511,
	kFLD_SHADING_COMMON_PSYS_TRANSPARENCY_R  	   	 = 512,
	kFLD_SHADING_COMMON_PSYS_TRANSPARENCY_G  	   	 = 513,
	kFLD_SHADING_COMMON_PSYS_TRANSPARENCY_B  	   	 = 514,
	kFLD_SHADING_COMMON_PSYS_TRANSPARENCY_METHOD   	 = 515,
	kFLD_SHADING_COMMON_PSYS_TRANSLUCENCE      	 	 = 516,
	kFLD_SHADING_COMMON_PSYS_BLOB_THRESHOLD    	 	 = 517,
	kFLD_SHADING_COMMON_PSYS_BLOB_NOISE    	 	     = 518,
	kFLD_SHADING_COMMON_PSYS_BLOB_NOISE_FREQUENCY    = 519,
	kFLD_SHADING_COMMON_PSYS_DENSITY    			 = 520,
	kFLD_SHADING_COMMON_PSYS_SIZE	 		     	 = 521,
	kFLD_SHADING_COMMON_PSYS_SIZE_RANGE	 		     = 522,
	kFLD_SHADING_COMMON_PSYS_BUOYANCY	 		     = 523,
	kFLD_SHADING_COMMON_PSYS_MASS	 		     	 = 524,
	kFLD_SHADING_COMMON_PSYS_ELASTICITY	 		     = 525,
	kFLD_SHADING_COMMON_PSYS_ATOMS_PER_SEC	 		 = 526,
	kFLD_SHADING_COMMON_PSYS_SPEED	 		     	 = 527,
	kFLD_SHADING_COMMON_PSYS_SPEED_RANGE	     	 = 528,
	kFLD_SHADING_COMMON_PSYS_LIFESPAN_MIN	 		 = 529,
	kFLD_SHADING_COMMON_PSYS_LIFESPAN_MAX	 		 = 530,
	kFLD_SHADING_COMMON_PSYS_RANDOMIZATION	 		 = 531,
	kFLD_SHADING_COMMON_PSYS_TIME_RANDOM	 		 = 532,
	kFLD_SHADING_COMMON_PSYS_COLLISIONS	 		     = 533,
	kFLD_SHADING_COMMON_PSYS_COLLISION_METHOD	 	 = 534,
	kFLD_SHADING_COMMON_PSYS_GROW_METHOD	 		 = 535,
	kFLD_SHADING_COMMON_PSYS_CYCLES	 		         = 536,
	kFLD_SHADING_COMMON_PSYS_ATTRACTION	 		     = 537,
	kFLD_SHADING_COMMON_PSYS_NOISE_ASPECT 		     = 538,
	kFLD_SHADING_COMMON_PSYS_SPLIT_TIME	 		     = 539,
	kFLD_SHADING_COMMON_PSYS_NUM_CHILDREN	 		 = 540,
	kFLD_SHADING_COMMON_PSYS_BRANCH_ANGLE	 		 = 541,

	kFLD_SHADING_COMMON_PSYS_FRICTION	 		 	 = 542,
	kFLD_SHADING_COMMON_PSYS_UNUSED	 		 		 = 543,
	kFLD_SHADING_COMMON_PSYS_SPEED_DECAY	 		 = 544,
	kFLD_SHADING_COMMON_PSYS_BEND_U	 		 		 = 545,
	kFLD_SHADING_COMMON_PSYS_BEND_V	 		 		 = 546,
	kFLD_SHADING_COMMON_PSYS_CURL	 		 		 = 547,
	kFLD_SHADING_COMMON_PSYS_BLOB_LIGHTING	 		 = 548,
	kFLD_SHADING_COMMON_PSYS_BLUR_LENGTH	 		 = 549,
	kFLD_SHADING_COMMON_PSYS_BLUR_QUALITY	 		 = 550,
	kFLD_SHADING_COMMON_PSYS_START_FRAME	 		 = 551,
	kFLD_SHADING_COMMON_PSYS_END_FRAME	 		     = 552,
	kFLD_SHADING_COMMON_PSYS_SURFACE_SHADING	 	 = 553,
	kFLD_SHADING_COMMON_PSYS_DIFFUSION_METHOD	 	 = 554,
	kFLD_SHADING_COMMON_PSYS_USE_PARTICLE_FILE	 	 = 555,
	kFLD_SHADING_COMMON_PSYS_HAIR_LENGTH_MAX	 	 = 556,
	kFLD_SHADING_COMMON_PSYS_HAIR_LENGTH_MIN	 	 = 557,
	kFLD_SHADING_COMMON_PSYS_HAIR_STIFFNESS	 		 = 558,
	kFLD_SHADING_COMMON_PSYS_HAIR_SEGMENTS	 		 = 559,

	/*
	// Particle systems are encrypted, and these block defines
	// are used within isFieldAllowed to check for the particle
	// system ranges.  Please keep these constants up to date
	*/

#define kFLD_SHADING_PSYS_END_BLOCK					559

	kFLD_SHADING_COMMON_PROPS_PROP_MASS	 		 	 = 560,
	kFLD_SHADING_COMMON_PROPS_DENSITY	 		 	 = 561,
	kFLD_SHADING_COMMON_PROPS_ELASTICITY	 		 = 562,
	kFLD_SHADING_COMMON_PROPS_FRICTION	 		     = 563,
	kFLD_SHADING_COMMON_PROPS_DRAG_COEFF	 		 = 564,

	kFLD_SHADING_DYN_GRAVITY	 		     		 = 565,
	kFLD_SHADING_DYN_AIR_DENSITY	 		         = 566,
	kFLD_SHADING_DYN_FORCE_SCALE	 		         = 567,
	kFLD_SHADING_DYN_TIME_SCALE	 		             = 568,
	kFLD_SHADING_DYN_FLOOR	 		                 = 569,
	kFLD_SHADING_DYN_FLOOR_OFFSET	 		         = 570,
	kFLD_SHADING_DYN_CIELING	 		             = 571,
	kFLD_SHADING_DYN_CIELING_OFFSET	 		         = 572,
	kFLD_SHADING_DYN_LEFT	 		     			 = 573,
	kFLD_SHADING_DYN_LEFT_OFFSET	 		         = 574,
	kFLD_SHADING_DYN_RIGHT	 		     			 = 575,
	kFLD_SHADING_DYN_RIGHT_OFFSET	 		     	 = 576,
	kFLD_SHADING_DYN_FRONT	 		     			 = 577,
	kFLD_SHADING_DYN_FRONT_OFFSET	 		         = 578,
	kFLD_SHADING_DYN_BACK	 		     			 = 579,
	kFLD_SHADING_DYN_BACK_OFFSET	 		     	 = 580,

	kFLD_SHADING_DYN_TURB_TYPE	 		             = 581,
	kFLD_SHADING_DYN_TURB_INTENSITY	 		     	 = 582,
	kFLD_SHADING_DYN_TURB_SPREAD	 		     	 = 583,
	kFLD_SHADING_DYN_TURB_PERSISTANCE	 		     = 584,
	kFLD_SHADING_DYN_TURB_SPACE_RESOLUTION	 		 = 585,
	kFLD_SHADING_DYN_TURB_TIME_RESOLUTION	 		 = 586,
	kFLD_SHADING_DYN_TURB_ROUGHNESS	 		         = 587,
	kFLD_SHADING_DYN_TURB_VARIABILITY	 		     = 588,
	kFLD_SHADING_DYN_TURB_GRANULARITY	 		     = 589,
	kFLD_SHADING_DYN_TURB_ANIMATED	 		     	 = 590,

	kFLD_SHADING_DYN_WALL_FRICTION	     			 = 591,
	kFLD_SHADING_DYN_WALL_ELASTICITY 		     	 = 592,

	kFLD_SHADING_COMMON_MATTE_OBJECT				 = 593,

	kFLD_SHADING_FOG_MIN_DISTANCE					 = 594,
	kFLD_SHADING_FOG_MAX_DISTANCE					 = 595,

	kFLD_SHADING_FILTER_TYPE						 = 596,
	kFLD_SHADING_CACHE								 = 597,
	kFLD_SHADING_COMMON_REFLECT_BACKGROUND		     = 598,
	kFLD_SHADING_SHADERGLOW_HALO_INTENSITY	 		 = 599,

    kFLD_SHADING_CLEARCOAT_ACTIVE                    = 600,
    kFLD_SHADING_CLEARCOAT_INDEX                     = 601,
    kFLD_SHADING_CLEARCOAT_SCALE                     = 602,
    kFLD_SHADING_CLEARCOAT_BIAS                      = 603,
    kFLD_SHADING_CLEARCOAT_MATERIAL_CODE             = 604,
    kFLD_SHADING_TRANSPARENCY_MATERIAL_CODE          = 605,

	kFLD_SHADING_LIGHTTUNNEL_ENABLED				 = 606,
	kFLD_SHADING_LIGHTTUNNEL_NUMBEROFBANDS			 = 607,
	kFLD_SHADING_LIGHTTUNNEL_INTENSITY				 = 608,
	kFLD_SHADING_LIGHTTUNNEL_COLOR_R				 = 609,
	kFLD_SHADING_LIGHTTUNNEL_BANDWIDTH				 = 610,
	kFLD_SHADING_LIGHTTUNNEL_BANDFRINGE				 = 611,
	kFLD_SHADING_LIGHTTUNNEL_VISIBLE				 = 612,

   kFLD_SHADING_GEOMETRIC_TYPE                = 613,
   kFLD_SHADING_GEOMETRY_SOURCE_TEXTURE       = 614,
   kFLD_SHADING_GEOMETRIC_SCALE               = 615,
   kFLD_SHADING_GEOMETRIC_ROTATE              = 616,
   kFLD_SHADING_GEOMETRIC_HEIGHT              = 617,

   kFLD_SHADING_MASTERLIGHT_AO_CONTRAST       = 618,

/* PLEASE ADD NEW IDS ABOVE HERE, and update the MAX_SHADING_ANIM_ID */
/* IDS should numerically follow from the previous id( avoid skips ) */

	MAX_SHADING_ANIM_ID                              = 619,

    /*Fix Sug #224047*/
    /*Below items are only used to identify a UI_Element when scripting shader.
      It can not be animated, so its values must greater than "MAX_SHADING_ANIM_ID"!!!
    */
    kFLD_SHADING_COMMON_BUMP_                        = MAX_SHADING_ANIM_ID + 1,
    kFLD_SHADING_COMMON_DISPLACEMENT_                = MAX_SHADING_ANIM_ID + 2,
    kFLD_SHADING_COMMON_SHADINGMAP_                  = MAX_SHADING_ANIM_ID + 3,
    kFLD_SHADING_COMMON_EMIT_PARTICLES_              = MAX_SHADING_ANIM_ID + 4,
    kFLD_SHADING_COMMON_CONCENTRATIO_                = MAX_SHADING_ANIM_ID + 5,
    kFLD_SHADING_COMMON_CONTRAST_                    = MAX_SHADING_ANIM_ID + 6,
    kFLD_SHADING_COMMON_REFRACTIVEMATERIAL_          = MAX_SHADING_ANIM_ID + 7,
    kFLD_SHADING_COMMON_PSYS_PRESET_                 = MAX_SHADING_ANIM_ID + 8,
    kFLD_SHADING_COMMON_PSYS_USE_FILE_               = MAX_SHADING_ANIM_ID + 9,
    kFLD_SHADING_COMMON_PSYS_PARTICLE_FILE_          = MAX_SHADING_ANIM_ID + 10,
    kFLD_SHADING_COMMON_PSYS_MOTION_TYPE_            = MAX_SHADING_ANIM_ID + 11,
    kFLD_SHADING_COMMON_PSYS_START_FRAME_            = MAX_SHADING_ANIM_ID + 12,
    kFLD_SHADING_COMMON_PSYS_END_FRAME_              = MAX_SHADING_ANIM_ID + 13,
    kFLD_SHADING_COMMON_PSYS_BLOB_MAP_               = MAX_SHADING_ANIM_ID + 14,
    kFLD_SHADING_COMMON_PSYS_HAIR_LENGTH_MAP_        = MAX_SHADING_ANIM_ID + 15,
    kFLD_SHADING_COMMON_PSYS_DIFFUSION_              = MAX_SHADING_ANIM_ID + 16,
    kFLD_SHADING_COMMON_PSYS_DIFFUSION_RATE_         = MAX_SHADING_ANIM_ID + 17,
    kFLD_SHADING_COMMON_PSYS_COLLISIONS_             = MAX_SHADING_ANIM_ID + 18,
    kFLD_SHADING_COMMON_PSYS_HIT_METHOD_             = MAX_SHADING_ANIM_ID + 19,
    kFLD_SHADING_PHONG_GLOSS_                        = MAX_SHADING_ANIM_ID + 20,
    kFLD_SHADING_PHONG_SPECULARITY_                  = MAX_SHADING_ANIM_ID + 21,
    kFLD_SHADING_PHONG_REFLECTION_                   = MAX_SHADING_ANIM_ID + 22,
    kFLD_SHADING_BLINN_GLOSS_                        = MAX_SHADING_ANIM_ID + 23,
    kFLD_SHADING_BLINN_SPECULARITY_                  = MAX_SHADING_ANIM_ID + 24,
    kFLD_SHADING_BLINN_REFLECTION_                   = MAX_SHADING_ANIM_ID + 25,
    kFLD_SHADING_CLEARCOAT_MATERIAL_                 = MAX_SHADING_ANIM_ID + 26,
    kFLD_SHADING_BACKGROUND_SEQUENCE_                = MAX_SHADING_ANIM_ID + 27,
    kFLD_SHADING_FOG_DENSITY_MAP_                    = MAX_SHADING_ANIM_ID + 28,
    kFLD_SHADING_SHADERGLOW_AUTO_EXPOSURE_           = MAX_SHADING_ANIM_ID + 29,
    kFLD_SHADING_TONE_MAPPING_GAMMA_                 = MAX_SHADING_ANIM_ID + 30,
    kFLD_SHADING_TONE_MAPPING_EXPOSURE_              = MAX_SHADING_ANIM_ID + 31,
    kFLD_SHADING_TONE_MAPPING_SATURATION_            = MAX_SHADING_ANIM_ID + 32,
    kFLD_SHADING_GROUND_PLANE_PREVIEW_               = MAX_SHADING_ANIM_ID + 33,
    kFLD_SHADING_GROUND_PLANE_HEIGHT_                = MAX_SHADING_ANIM_ID + 34,
    kFLD_SHADING_GROUND_PLANE_SHADOWS_               = MAX_SHADING_ANIM_ID + 35,
    kFLD_SHADING_GROUND_PLANE_SHADOW_BLUR_           = MAX_SHADING_ANIM_ID + 36,
    kFLD_SHADING_GROUND_PLANE_SHADOW_POSITION_       = MAX_SHADING_ANIM_ID + 37,
    kFLD_SHADING_GROUND_PLANE_SHADOW_TRANSPARENCY_   = MAX_SHADING_ANIM_ID + 38,
    kFLD_SHADING_GROUND_PLANE_REFLECTION_            = MAX_SHADING_ANIM_ID + 39,
    kFLD_SHADING_GROUND_PLANE_REFLECTIVITY_          = MAX_SHADING_ANIM_ID + 40,
    kFLD_SHADING_GROUND_PLANE_REFLECTION_DEPTH_      = MAX_SHADING_ANIM_ID + 41,
    kFLD_SHADING_GROUND_PLANE_REFLECTION_BLUR_       = MAX_SHADING_ANIM_ID + 42,
    kFLD_SHADING_GROUND_PLANE_REFLECTION_BLUR_DEPTH_ = MAX_SHADING_ANIM_ID + 43,
    kFLD_SHADING_COMMON_TEXTURE_OVERLAY_             = MAX_SHADING_ANIM_ID + 44,
    kFLD_SHADING_COMMON_TEXTURE_COLOR_REMAP_         = MAX_SHADING_ANIM_ID + 45,
    kFLD_SHADING_COMMON_TEXTURE_SMEAR_MAP_           = MAX_SHADING_ANIM_ID + 46,
    kFLD_SHADING_RAMP_POSITION_                      = MAX_SHADING_ANIM_ID + 47,
    kFLD_SHADING_RAMP_RAMP_COLOR_                    = MAX_SHADING_ANIM_ID + 48,
    kFLD_SHADING_RAMP_INTENSITY_                     = MAX_SHADING_ANIM_ID + 49,
    kFLD_SHADING_STENCIL_IMAGE_                      = MAX_SHADING_ANIM_ID + 50,
    kFLD_SHADING_STENCIL_MASK_                       = MAX_SHADING_ANIM_ID + 51,
    kFLD_SHADING_CUBE_FINITE_SIZE_                   = MAX_SHADING_ANIM_ID + 52,
    kFLD_SHADING_CUBE_CROSS_ORIENTATION_             = MAX_SHADING_ANIM_ID + 53,
    kFLD_SHADING_BALL_IMAGE_                         = MAX_SHADING_ANIM_ID + 54,
    kFLD_SHADING_SPHERE_SOURCE_TEXTURE_              = MAX_SHADING_ANIM_ID + 55,
    kFLD_SHADING_SKY_CLOUD_TEXTURE_                  = MAX_SHADING_ANIM_ID + 56,
    kFLD_SHADING_SFILE_SOURCE_TEXTURE_               = MAX_SHADING_ANIM_ID + 57,
    kFLD_SHADING_CURVATURE_TYPE_                     = MAX_SHADING_ANIM_ID + 58,
    kFLD_SHADING_CURVATURE_DISPLAY_                  = MAX_SHADING_ANIM_ID + 59,
    kFLD_SHADING_CURVATURE_SCALE_                    = MAX_SHADING_ANIM_ID + 60,
    kFLD_SHADING_BACKGROUND_BACKDROP_                = MAX_SHADING_ANIM_ID + 61,
    kFLD_SHADING_IBL_REFLECTION_MAP_                 = MAX_SHADING_ANIM_ID + 62, 
    kFLD_SHADING_IBL_REFLECTION_MAP_ROTATION_        = MAX_SHADING_ANIM_ID + 63, 
    kFLD_SHADING_VOLUME_PIX_SEQUENCE_                = MAX_SHADING_ANIM_ID + 64,
    kFLD_SHADING_CUBE_CROSS_IMAGE_                   = MAX_SHADING_ANIM_ID + 65,
    kFLD_SHADING_CUBE_RIGHT_IMAGE_                   = MAX_SHADING_ANIM_ID + 66,
    kFLD_SHADING_CUBE_LEFT_IMAGE_                    = MAX_SHADING_ANIM_ID + 67,
    kFLD_SHADING_CUBE_TOP_IMAGE_                     = MAX_SHADING_ANIM_ID + 68,
    kFLD_SHADING_CUBE_BOTTOM_IMAGE_                  = MAX_SHADING_ANIM_ID + 69,
    kFLD_SHADING_CUBE_FRONT_IMAGE_                   = MAX_SHADING_ANIM_ID + 70,
    kFLD_SHADING_CUBE_BACK_IMAGE_                    = MAX_SHADING_ANIM_ID + 71,
    kFLD_SHADING_FILE_IMAGE_                         = MAX_SHADING_ANIM_ID + 72,
    kFLD_SHADING_COMMON_VRED_MATERIAL_TAG_           = MAX_SHADING_ANIM_ID + 73
    /* End fix */

} AlShadingFields;

#endif	/* ALSHADINGFIELDS_H */

