/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlShadingFieldItem - Items for maintaining AlShader parameters.
//
//	.SECTION Description
//		This class is derived from the AlLinkItem class, and is used
//		to maintain one element of a list of parameters which are
//		valid for a particular AlShader, AlTexture, or AlEnvironment.
//

#ifndef _AlShadingFieldItem
#define _AlShadingFieldItem

#include <AlStyle.h>

class STUDIOAPI_DECL AlShadingFieldItem : public AlLinkItem {
	friend class			AlShader;
	friend class			AlTexture;
	friend class			AlEnvironment;

	public:
		AlShadingFields		field() const;
		AlShadingFieldItem*	nextField() const;
		AlShadingFieldItem*	prevField() const;

	protected:
							AlShadingFieldItem(AlShadingFields);
		virtual				~AlShadingFieldItem();

	private:
		AlShadingFields		fField;
};

#endif
