/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlSettable - Encapsulates methods common to Alias objects which can belong to sets.
//
//	.SECTION Description
//
//		This class is a base class for all objects which can be
//		contained in a set. It provides the methods necessary
//		to access the set methods of these objects.
//

//-
//	Note that this class relies on the fact the classes derived from it
//	overload the extractType function in AlObject.  In theory, we should be
//	introducing a new base class, AlTypeable, which has a pure virtual
//	extractType method.  But this introduces a lot of extra code.  Let's just
//	assume for now that if AlFoo inherits AlSettable, then AlFoo provides
//	a working extractType method.
//+

#ifndef _AlSettable
#define _AlSettable

#include <AlStyle.h>

class AlSet;
class AlIterator;
class AlSetMember;

class STUDIOAPI_DECL AlSettable {
	friend class		AlFriend;
public:
	AlSet*				firstSet() const;

	AlSet*				nextSet( const AlSet* ) const;
	AlSet*				prevSet( const AlSet* ) const;

	statusCode			nextSetD( AlSet* ) const;
	statusCode			prevSetD( AlSet* ) const;

	statusCode			applyIteratorToSets( AlIterator*, int& );

	statusCode			removeFromAllSets();
	statusCode			removeFromSet( AlSet *set );
	statusCode			addToSet( AlSet *set );
	AlSetMember*		isSetMember( const AlSet *set ) const;

protected:
						AlSettable();
	virtual				~AlSettable();

	virtual API_BOOLEAN		extractType( int&, void *&, void *& ) const;

private:
	// Disallow the copy constructor and copy assignment
	AlSettable (const AlSettable &);
	AlSettable &operator= (const AlSettable &);
};
#endif

