/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlSetMember - Basic Interface to the members of Alias set structures.
//
//	.SECTION Description
//		This class provides utility functions for set operations.  The first
//		AlSetMember of a set can be retrieved from the AlSet.  Then iteration
//		through the sets can be performed using the calls provided within
//		this class.
//
//		The following classes can be grouped into sets: AlDagNode, AlPerspectiveCamera,
//		AlCurveCV, AlPolysetVertex and AlSurfaceCV.  These classes use
//		multiple inheritance which include the AlSettable class.  Use the addToSet()
//		method of class AlSettable to add the object to a set.
//

#ifndef _AlSetMember
#define _AlSetMember

#include <AlObject.h>

class AlSet;
struct Set;

class STUDIOAPI_DECL AlSetMember : public AlObject {
	friend class AlFriend;

public:
	virtual					~AlSetMember();
	virtual AlObject*		copyWrapper() const;

	virtual	AlObjectType 	type() const;

	AlSetMember*			nextSetMember() const;
	AlSetMember*			prevSetMember() const;

	statusCode				nextSetMemberD();
	statusCode				prevSetMemberD();

	AlObject*				object() const;
	AlSet*					set() const;

	statusCode				removeFromSet( AlSet *set );

private:
	Set *fSet;

private:
							AlSetMember( Set *fSet );
	static void				initMessages();
	static void				finiMessages();
};

#endif // _AlSetMember

