/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlSet - Basic Interface to Alias set structures.
//
//	.SECTION Description
//		A set can be described as a storable list.  A set can contain
//		any combination of cameras, dag nodes, curve CV's and surface CV's,
//		or polyset vertices.
//		A set can be exclusive or multi - exclusive means that a member
//		of a set can be in no other set; multi means that a member of the
//		set can be in any other non-exclusive set.
//
//		You can access the members of a set by traversing a set's list of
//		members.
//
//		If you remove all members of a set, the empty AlSet object must be
//		explicitly deleted.  If you store an empty set, it will be lost
//		when you retrieve your wire file into the interactive Alias package.
//
//		The following classes can be grouped into sets: AlDagNode, AlPerspectiveCamera,
//		AlCurveCV, AlPolysetVertex and AlSurfaceCV.
//

#ifndef _AlSet
#define _AlSet

#include <AlObject.h>

struct Set;
struct Dag_node;

class AlSetMember;
class AlIterator;

class STUDIOAPI_DECL AlSet : public AlObject {
	friend class			AlFriend;

public:
							AlSet();
	virtual					~AlSet();
	virtual statusCode		deleteObject();
	virtual AlObject		*copyWrapper() const;

	statusCode				create( const API_BOOLEAN );

	virtual AlObjectType	type() const;

	virtual const char*		name() const;
	virtual statusCode		setName( const char* );

	AlSet*			nextSet() const;
	AlSet*			prevSet() const;

	statusCode		nextSetD();
	statusCode		prevSetD();

	API_BOOLEAN			isEmpty() const;
	API_BOOLEAN			isExclusive() const;
	int				numberOfMembers() const;
	
	statusCode		setExclusive( const API_BOOLEAN on );

	AlSetMember		*firstMember() const;
	statusCode		applyIteratorToMembers( AlIterator* iter, int& );

private:
	static void 	initMessages();
	static void		finiMessages();
};

#endif // _AlSet
