/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlRevSurfAttributes
#define _AlRevSurfAttributes

//
//	.NAME AlRevSurfAttributes - Interface to Alias arc curve attributes.
//
//	.SECTION Description
//
//		AlRevSurfAttributes is a class derived from the AlAttributes class.
//		This class allows access to some of the attributes of a revolved
//		surface, in this case the start and end angles of revolution.
//
//		When querying the attributes of a revolved surface (retrieved
//		from IGES or created in Alias with exact ON) the first
//		attribute will be an AlRevSurfAttributes, the second will be
//		an AlLineAttributes representing the axis of revolution, and
//		the remainder of the attributes describe the line which was
//		revolved to generate the surface.
//

#include <AlAttributes.h>

class STUDIOAPI_DECL AlRevSurfAttributes : public AlAttributes {
	friend class			AlFriend;

public:
	virtual AlObjectType			type() const;
	AlObject*						copyWrapper() const;

	double					startAngle() const;
	double					endAngle() const;

protected:
							AlRevSurfAttributes(struct Spline_surface*);
	virtual					~AlRevSurfAttributes();
};

#endif
