/********************************************************************
* (C) Copyright 2018 by Autodesk, Inc. All Rights Reserved. By using
* this code,  you  are  agreeing  to the terms and conditions of the
* License  Agreement  included  in  the documentation for this code.
* AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
* CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
* IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
* DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
* DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
*
* Use, duplication,  or disclosure by the U.S. Government is subject
* to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
* Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
* (Rights  in Technical Data and Computer Software),  as applicable.
*******************************************************************/
//
//	.NAME AlReferenceObject - A base class that encapsulates access to 
//                             Reference Objects.
//
//

#ifndef _AlReferenceObject
#define _AlReferenceObject

#include <AlObject.h>

namespace awDMD
{
    class RefObject;
}

class AlReferenceFile;

class STUDIOAPI_DECL AlReferenceObject : public AlObject
{
    friend class            AlFriend;
public:
    virtual                 ~AlReferenceObject();

    virtual statusCode      deleteObject();
    virtual AlObject*       copyWrapper() const;
    virtual AlObjectType    type() const;
    virtual const char*     name() const;

    bool                    isVisible() const;
    int                     getReferenceType() const;
    AlShader*               getShader() const;
    AlShader*               getNextShader( const AlShader* ) const;
    int                     getLayerID() const;

    statusCode              getTransformationMatrix( double[4][4] ) const;
    AlReferenceFile*        getOwner() const;

protected:
    AlReferenceObject();
private:
    awDMD::RefObject*       refObject();

    static void initMessages();
    static void finiMessages();
};

#endif   // _AlReferenceObject
