/********************************************************************
* (C) Copyright 2018 by Autodesk, Inc. All Rights Reserved. By using
* this code,  you  are  agreeing  to the terms and conditions of the
* License  Agreement  included  in  the documentation for this code.
* AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
* CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
* IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
* DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
* DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
*
* Use, duplication,  or disclosure by the U.S. Government is subject
* to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
* Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
* (Rights  in Technical Data and Computer Software),  as applicable.
*******************************************************************/
//
//	.NAME AlReferenceLayer - A base class that encapsulates access to 
//                             Reference Layers.
//
//

#ifndef _AlReferenceLayer
#define _AlReferenceLayer

#include <AlObject.h>

namespace awDMD
{
    class RefLayer;
}

class AlReferenceFile;

class STUDIOAPI_DECL AlReferenceLayer : public AlObject
{
    friend class            AlFriend;
public:
    enum SymmetryState
    {
        Original = 1,
        Mirror = 2,
        BothSides = 3
    };

    virtual                 ~AlReferenceLayer();

    virtual statusCode      deleteObject();
    virtual AlObject*       copyWrapper() const;
    virtual AlObjectType    type() const;

    bool                    isVisible() const;

    statusCode              getColour( unsigned char rgba[4] ) const;
    statusCode              symmetricOrigin( double& x, double& y, double& z ) const;
    statusCode              symmetricNormal( double& x, double& y, double& z ) const;
    SymmetryState           symmetryState() const;

    AlReferenceFile*        getOwner() const;

protected:
    AlReferenceLayer();
private:
    awDMD::RefLayer*        refLayer();

    static void initMessages();
    static void finiMessages();
};

#endif   // _AlReferenceLayer
