/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlReferenceFileSet - A base class that encapsulates access to 
//                             Reference File Sets.
//
//

#ifndef _AlReferenceFileSet
#define _AlReferenceFileSet

#include <AlObject.h>

class AlReferenceFile;

class STUDIOAPI_DECL AlReferenceFileSet	: public AlObject
{

	friend class			AlFriend;
public:
	virtual					~AlReferenceFileSet();

	virtual statusCode		deleteObject();
	virtual AlObject*  		copyWrapper() const;

	virtual AlObjectType	type() const;

	virtual const char*		name() const;
	virtual statusCode		setName( const char* );

    bool                    isAlternative() const;
    bool                    isVisible() const;
    statusCode              setVisible(bool isVisible);
    bool                    hasColour() const;
    bool                    getColour(unsigned char rgba[4]) const;
    statusCode              setColour(unsigned char rgba[4]);

    AlReferenceFile*		firstReferenceFile();
	AlReferenceFile*		nextReferenceFile( AlReferenceFile* );
	statusCode		        nextReferenceFileD( AlReferenceFile*, bool rootOnly = false );

    statusCode              addReferenceFile( AlReferenceFile* );
    statusCode              addReferenceFileToAlternative(AlReferenceFile*);
    statusCode              removeReferenceFileFromAlternative(AlReferenceFile*);

protected:
							AlReferenceFileSet();
private:
	static void				initMessages();
	static void				finiMessages();
};

#endif   // _AlReferenceFileSet
