/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlReferenceFile - A base class that encapsulates access to 
//                           Reference File.
//
//

#ifndef _AlReferenceFile
#define _AlReferenceFile

#include <AlObject.h>

enum ReferenceFileStatus
{
    kFileNotFound,
    kStale,
    kUpToDate,
    kSourceWireNotFound,
    kError
};

class AlReferenceObject;
class AlReferenceLayer;
class AlReferenceFileSet;
class AlTM;

class STUDIOAPI_DECL AlReferenceFile : public AlObject
{
	friend class			AlFriend;
public:
    typedef struct UUID { unsigned int x[4]; } UUID;
	virtual					~AlReferenceFile();

	virtual statusCode		deleteObject();
	virtual AlObject*  		copyWrapper() const;

	virtual AlObjectType	type() const;

	virtual const char*		name() const;
    const char*		        fileName() const;
    const char*		        sourceWirefile() const;
    UUID                    getUuid() const;
    

    ReferenceFileStatus     status() const;

    double                  curveTolerance() const;
    double                  surfaceTolerance() const;
    int                     numLayers() const;
    int                     numComponents() const;

    bool                    isInstance() const;
    bool                    isVisible() const;
    statusCode              setVisible(bool isVisible);
    bool                    hasColour() const;
    bool                    getColour(unsigned char rgba[4]) const;
    statusCode              setColour(unsigned char rgba[4]);

    statusCode localTransformationMatrix( double[4][4] ) const;
    statusCode globalTransformationMatrix( double[4][4] ) const;
    statusCode inverseGlobalTransformationMatrix( double[4][4] ) const;

    statusCode localTransformationMatrix( AlTM& ) const;
    statusCode globalTransformationMatrix( AlTM& ) const;
    statusCode inverseGlobalTransformationMatrix( AlTM& ) const;

    statusCode translation( double&, double&, double& ) const;
    statusCode rotation( double&, double&, double& ) const;
    statusCode scale( double&, double&, double& ) const;
    statusCode rotatePivot( double&, double&, double& ) const;
    statusCode scalePivot( double&, double&, double& ) const;

    statusCode setTranslation( double, double, double );
    statusCode setWorldTranslation( double, double, double );
    statusCode setRotation( double, double, double );
    statusCode setScale( double, double, double );

    statusCode setRotatePivot( double, double, double );
    statusCode setScalePivot( double, double, double );

    statusCode copyTransform( AlReferenceFile* other );

    AlReferenceObject*      firstObject() const;
    statusCode              nextObjectD( AlReferenceObject* ) const;
    AlShader*               firstShader() const;
    statusCode              nextShaderD( AlShader* ) const;

    AlReferenceLayer*       getLayer( int num ) const;
    AlReferenceFileSet*     getOwner() const;

    AlReferenceFile*        getParentReference() const;

    AlReferenceFile*        firstChildReference() const;
    statusCode              nextChildReferenceD( AlReferenceFile* ) const;
    statusCode              addChildReference( AlReferenceFile* );

    static AlReferenceFile* createEmptyReference( const char* source );

protected:
							AlReferenceFile();
private:
	static void				initMessages();
	static void				finiMessages();
};

#endif   // _AlReferenceFile
