/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//+
//	.NAME AlRadialLocator - Interface to Alias Radial locators
//
//	.SECTION Description
//		A Radial locator is used to create a radial measure of a curve or a
//		curve on surface in their respective parametric spaces. This class
//		methods to create the locator, query the radius and set the display
//		attributes of the radial locator in the Alias windows. If the curve
//		or curve on surface on which this locator is created is deleted, the
//		locator is automatically deleted.

#ifndef __AlRadialLocator
#define __AlRadialLocator


#include <AlLocator.h>

class STUDIOAPI_DECL AlRadialLocator : public AlLocator{
	friend class			AlFriend;

public:
	AlRadialLocator();
	~AlRadialLocator();
	virtual AlObject *	    copyWrapper() const;
	virtual AlObjectType	type() const;
	statusCode		        create(const AlCurve *, double u = 0.0);
	statusCode		        create(const AlCurveOnSurface *, double u = 0.0);

	statusCode              radius(double &) const;
	statusCode              center(double &, double &, double &) const;
	statusCode              setParameter(double);
	statusCode              parameter(double &) const;
	statusCode              setOffset(double);
	statusCode              offset(double &) const;
	statusCode              setLeftJustify(API_BOOLEAN);
	statusCode              leftJustify(API_BOOLEAN &) const;
	
	AlObject *				attachedTo();

	statusCode		        diameterCreate(const AlCurve *, double u = 0.0);
};


#endif


