/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlPolysetVertex
#define _AlPolysetVertex

//
//	.NAME AlPolysetVertex - Interface to Alias polyset vertices.
//
//	.SECTION Description
//
//		WARNING: AlPolysetVertex is deprecated, use AlMesh instead.
//
//		AlPolysetVertex is the interface to the vertex data of Alias'
//		polyset objects. An AlPolysetVertex can only be created through
//		AlPolyset::newVertex() method, and it can be deleted only through
//		the AlPolyset::deleteVertex() method.
//		AlPolysetVertex's have similar methods to AlCurveCV and
//		AlSurfaceCV for getting and setting the unaffected and affected
//		positions of verticies.
// .br
//		An AlPolysetVertex defines a location in space for a corner of
//		an AlPolygon.
//

#include <AlObject.h>
#include <AlClusterable.h>
#include <AlAnimatable.h>
#include <AlSettable.h>
#include <AlPickable.h>

class AlTM;
struct Dag_node;

class PS_Vertex;

class STUDIOAPI_DECL AlPolysetVertex	: public AlObject , public AlClusterable , public AlAnimatable , public AlSettable , public AlPickable {
	friend class				AlFriend;
public:

								AlPolysetVertex();
	virtual						~AlPolysetVertex();
	virtual AlObject*			copyWrapper() const;


	virtual AlObjectType		type() const;

	statusCode					worldPosition( double&, double&, double& )const;
	statusCode					affectedPosition( AlTM&, double&, double&, double& )const;
	statusCode					unaffectedPosition( double&, double&, double& )const;
	statusCode					setWorldPosition( double, double, double, API_BOOLEAN );
	statusCode					setWorldPosition( double, double, double, AlTM );
	statusCode					setUnaffectedPosition( double, double, double );

	statusCode					normal( double&, double&, double& ) const;
	statusCode					setNormal( double, double, double );
	statusCode					freezeNormalFlag( API_BOOLEAN& ) const;
	statusCode					setFreezeNormalFlag( API_BOOLEAN );

	statusCode					st( double&, double& ) const;
	statusCode					setSt( double, double );

	statusCode					color( double&, double&, double&, double& ) const;
	statusCode					setColor( double, double, double, double );
	statusCode					unsetColor();
	
	int							index() const;
	AlPolyset*					polyset() const;

	statusCode					blindData( int, long&, const char *& );
	statusCode 					setBlindData( int, long, const char * );
	statusCode					removeBlindData( int );

	statusCode            		doUpdates( API_BOOLEAN newState = TRUE );

protected:
								AlPolysetVertex( Dag_node* );
	statusCode					create( AlPolyset*, int );
	statusCode					create( AlPolyset*, PS_Vertex* );

	Dag_node*					fParent;

private:
	API_BOOLEAN               		updateOn;
	API_BOOLEAN               		updateNeeded;
	void                  		updatePerform();

	static void					initMessages();
	static void					finiMessages();

	virtual API_BOOLEAN				extractType( int&, void*&, void*& ) const;
};

#endif
