/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlPolysetNode
#define _AlPolysetNode

//
//	.NAME AlPolysetNode - Dag node class for polysets.
//
//	.SECTION Description
//
//		WARNING: AlPolysetNode is deprecated, use AlMeshNode instead.
//
//		AlPolysetNode is the class used to access and manipulate
//		polysets within the dag.  This class behaves like other dag nodes
//		(see AlDagNode for a description of the usage and purpose of dag nodes)
//		except that you are not able to instantiate or create one (which is
//		done when creating a polyset).
// .br
//		The polyset() method returns a pointer to an AlPolyset object which
//		provides you with the methods used to modify the polyset. Polysets can
//		be created from scratch by calling the AlPolyset::create() method, or
//		read in from a wire file (see AlUniverse documentation).
//

#include <AlDagNode.h>

class STUDIOAPI_DECL AlPolysetNode : public AlDagNode {
	friend 					class AlFriend;
  public:

	virtual					~AlPolysetNode();
	virtual AlObject		*copyWrapper() const;

	virtual AlObjectType	type() const;

	AlPolyset*				polyset() const;
	AlPolyset*				polyset(AlTM&) const; 
	
	AlMeshNode*             convertToMesh() const;    

protected:
							AlPolysetNode();
private:
};

#endif
