/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

/*
//
//	.NAME AlPolygon - Interface to Alias polyset polygons.
//
//	.SECTION Description
//
//		WARNING: AlPolygon is deprecated, use AlMesh instead.
//
//		AlPolygon is the interface to the polygon data of Alias'
//		polyset objects.  To create a polygon, first instantiate and create
//		an AlPolyset and then use the AlPolyset::newPolygon() method to
//		create a new polygon. It is not possible to create a polygon
//		without a polyset.
//
//		A polygon is a collection of vertices from a particular polyset.
//
//		The only way to delete a polygon is with the AlPolyset::deletePolygon()
//		method.
//
//		Polygons are made of lists of vertices which you traverse using
//		an index through the vertex() method. You can also pack the
//		vertex information into an array using methods in this class.
//
*/

#ifndef _AlPolygon
#define _AlPolygon

#include <AlObject.h>

//
// These are to be used to pass to the fliping and rotating methods.

const unsigned int kPOLY_FLIP_NONE      =0x00000000;
const unsigned int kPOLY_FLIP_HORIZ     =0x00000001;
const unsigned int kPOLY_FLIP_VERT      =0x00000002;
const unsigned int kPOLY_FLIP_BOTH      =0x00000003;

const unsigned int kPOLY_ROT_0          =0x00000000;
const unsigned int kPOLY_ROT_90         =0x00000001;
const unsigned int kPOLY_ROT_180        =0x00000002;
const unsigned int kPOLY_ROT_270        =0x00000003;

extern "C"
{
	struct Dag_node;
}

class AlTM;
class AlIterator;
class PS_Polygon;

class STUDIOAPI_DECL AlPolygon : public AlObject {
	friend					class AlFriend;

public:

							AlPolygon();
	virtual 				~AlPolygon();
	virtual AlObject*		copyWrapper() const;

	virtual AlObjectType	type() const;

	int						numberOfVertices() const;
	AlPolysetVertex*		vertex( int ) const;
	statusCode				vertexD( int, AlPolysetVertex& ) const;

	statusCode				addVertex( int );
	statusCode				removeVertex( int );
	statusCode				verticesWorldPosition( double[] )const;
	statusCode				verticesAffectedPosition( const AlTM&, double[] )const;
	statusCode				verticesUnaffectedPosition( double[] )const;

	statusCode				addVertices( int, int[] );
	statusCode				removeVertices( int, int[] );

	statusCode				normal( double&, double&, double& ) const;
	statusCode				setNormal( double, double, double );
	statusCode				calcNormal();

	int						index();
	AlPolyset*				polyset() const;

	int						findVertexIndex( AlPolysetVertex* );
	int						vertexPolysetIndex( int vertexIndex );

	int						shaderIndex();
	statusCode				setShaderIndex( int );

	statusCode				st( int vertex, double &, double & );
	statusCode				setSt( int vertex, double, double );

	statusCode				normal( int vertex, double &, double &, double & );
	statusCode				setNormal( int vertex, double, double, double );

	API_BOOLEAN					queryPerPolyTextures() const;
	statusCode				setPerPolyTextures( API_BOOLEAN state );

	statusCode				queryPerPolyTextureOther1( unsigned short &index ) const;
	statusCode				setPerPolyTextureOther1( unsigned short index );

	statusCode				queryPerPolyTextureOther2( unsigned short &index ) const;
	statusCode				setPerPolyTextureOther2( unsigned short index );

	statusCode				queryPerPolyTextureIndex( unsigned short &index ) const;
	statusCode				setPerPolyTextureIndex( unsigned short index );

	statusCode				queryPerPolyTextureRotation( int &flag ) const;
	statusCode				setPerPolyTextureRotation( int flag );

	statusCode				queryPerPolyTextureFlip( int &flag ) const;
	statusCode				setPerPolyTextureFlip( int flag );

	statusCode				blindData( int, long&, const char *& );
	statusCode 				setBlindData( int, long, const char * );
	statusCode 				removeBlindData( int );

	statusCode 				applyIteratorToVertices( AlIterator*, int& ) const;

	statusCode              doUpdates( API_BOOLEAN newState = TRUE );

protected:

							AlPolygon( Dag_node* );
	statusCode 				create( AlPolyset*, int );
	statusCode				create( AlPolyset*, PS_Polygon* );

	Dag_node				*fParent;
private:
	API_BOOLEAN					updateOn;
	API_BOOLEAN					updateNeeded;
	void					updatePerform();

	static void				initMessages();
	static void				finiMessages();

	API_BOOLEAN					extractType( int&, void*&, void*& ) const;
};

#endif	/* _AlPolygon_h */
