/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//+
//	.NAME AlPoint - Contains functionality common to all Alias construction entity points.
//
//	.SECTION Description
//		This virtual class is derived from AlConstructionEntity and encapsulates methods
//		common to all the Alias point type such as space points, curve points,
//		curve on surface points, and surface points.

#ifndef __AlPoint
#define __AlPoint

#include <AlConstructionEntity.h>

class STUDIOAPI_DECL AlPoint : public AlConstructionEntity {
	friend class	    AlFriend;

public:

	virtual ~AlPoint();
	virtual AlObject *	    copyWrapper() const = 0;
	virtual AlObjectType    type() const;
	virtual statusCode      worldPosition(double &, double &, double &) const = 0;

protected:
	// This class is a pure virtual class. It cannot be instantiated.
	AlPoint();
};
#endif































