/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

/*
//
//	.NAME AlPlayBack - A static class for managing animation playback.
//
//	.SECTION Description
//		These set of static methods provide a plugin developer with the
//		ability to initiate and manage animation playback.  A callback
//		facility is also provided, which allows polling type plugins to
//		perform a limited set of operations after each frame has been
//		displayed.
//
//		Be VERY VERY CAREFUL about what you do in this callback.  As part of
//		its optimisation technique, a lot of animation information is
//		cached outside of the normal messaging system.  This means that
//		if you delete some animation objects while playback is active
//		then at some stage PowerAnimator will become very confused
//		(as in core dump confused).
//
//		Note that this class only functions in OpenAlias. In OpenModel
//		the class exists but does not do anything.
//
*/

#ifndef _AlPlayBack
#define _AlPlayBack

#include <AlStyle.h>

typedef	void (AlCallBack (void));

class STUDIOAPI_DECL AlPlayBack {
public:
static void playForward ();
static void playReverse ();
static void stop ();
static API_BOOLEAN inPlayBack ();
static void nextFrame ();
static void previousFrame ();
static void nextKeyframe ();
static void previousKeyframe ();
static void gotoStart ();
static void gotoEnd ();
static void gotoFrame (const double frame);
static AlCallBack *setCallBack (AlCallBack *callBack);
static void getStartEndBy (double &start, double &end, double &by);

private:
	// Do not create an instance of this
	//
	AlPlayBack ();
	~AlPlayBack ();
};


#endif // _AlPlayBack
