/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlPlaneAttributes
#define _AlPlaneAttributes

//
//	.NAME AlPlaneAttributes - Interface to Alias plane surface attributes.
//
//	.SECTION Description
//
//		AlPlaneAttributes is a class derived from the AlAttributes class.
//		This class allows access to the attributes for an plane.
//
//		The attributes which define a plane are the coefficients of
//		Ax + By + Cz + D = 0 and coordinates of the center of the plane.
//
//		At this time it is only possible to query an AlPlaneAttribute.
//		Further it is currently not possible to create a plane with
//		attributes either in OpenModel or Alias. This attribute is
//		provided for compatibility with IGES, and as such the only
//		way to get a plane with attributes into an Alias wire file
//		is to import an IGES file into Alias and then save a wire
//		file.
//

#include <AlAttributes.h>

class STUDIOAPI_DECL AlPlaneAttributes : public AlAttributes {
	friend class	AlFriend;

public:
	virtual AlObjectType			type() const;
	AlObject*						copyWrapper() const;

	statusCode		coefficients( double&, double&, double&, double& ) const;
	statusCode		centerPoint( double&, double&, double& ) const;

protected:
					AlPlaneAttributes(struct Spline_surface*);
	virtual			~AlPlaneAttributes();
};

#endif
