/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlPixFile - Interface to Alias Pix files
//
//	.SECTION Description
//		This class allows you to read and write Alias Pix files.
//

#ifndef _AlPixFile
#define _AlPixFile

#include <AlStyle.h>

typedef struct AlPixel {
	unsigned char a, b, g, r;
} AlPixel;

class STUDIOAPI_DECL AlPixFile
{
public:
	enum Format
	{	kAlias	= 1,
		kSGI	= 2,
		kGIF	= 3,	// read-only
		kTIFF	= 4,
		kRLA	= 9,
		kBMP32	= 12,
		kBMP24	= 13,
		kJPEG	= 17,
		kPNG	= 19,

		// high dynamic range formats not supported
		kTIFF16	= 5,
		kEXR	= 14,
		kHDR	= 15,
		kTIFF32	= 18,

		// Old deprecated formats no longer supported
		kFIT	= 6,
		kOMF	= 7,
		kTIM	= 8,
		kFIDO	= 10,
		kHARRY	= 11
	};

				AlPixFile();
	virtual		~AlPixFile();
	statusCode	openForRead( char *path );
	statusCode	openForWrite( char *path, int width, int height, int numChannels, Format fileFormat = kAlias );
	statusCode	close();
	int			read( AlPixel *ldata );
	int			write( AlPixel *ldata );
	int			width();
	int			height();
	int			numChannels();	
	statusCode	fileFormat( Format& );

private:
	void*		fileDesc;

private:
	// Disallow the copy constructor and copy assignment
	AlPixFile (const AlPixFile &);
	AlPixFile &operator= (const AlPixFile &);
};

#endif
