/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlPickable - Basic Interface to Alias objects which can be picked.
//
//	.SECTION Description
//		This class encapsulates the functionality of Alias objects
//		which have the capacity to be picked.  As expected, pickable
//		objects can either be picked or unpicked.
//

#ifndef _AlPickable
#define _AlPickable

#include <AlStyle.h>

class STUDIOAPI_DECL AlPickable {
	friend					class AlFriend;

public:
	statusCode				pick( void );
	statusCode				unpick( void );
	API_BOOLEAN					isPicked( void );
protected:
							AlPickable();
	virtual 				~AlPickable();

	virtual API_BOOLEAN			extractType( int&, void *&, void *& ) const;

private:
	// Disallow the copy constructor and copy assignment
	AlPickable (const AlPickable &);
	AlPickable &operator= (const AlPickable &);
};

#endif // _AlPickable
