/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

/*
//
//	.NAME AlPickList - A static class which gives access to the Alias pick list
//
//	.SECTION Description
//
//		This class gives access to the pick list, that is, those objects
//		which are currently active. Note that this will include objects
//		which are active in the MultiLister and not just those objects
//		active in the modeling windows.
//
*/

#ifndef _AlPickList_H
#define _AlPickList_H

#include <AlStyle.h>

class AlObject;
class AlIterator;
class AlIteratorWithParent;
class AlPickable;
class AlList;
class AlUserPickList;
class AlDagNode;

extern "C" {
	struct Pick_item;
	struct IR_ShaderEntry;
}

class STUDIOAPI_DECL  AlPickList {
	friend					class AlUniverse;
	friend					class AlFriend;
	friend					void handlePickListCleared(void*);

public:
	enum AlPickMaskType {
		kMaskUnchanged 		= 0x0,
		kMaskTemplate 		= 0x1,
		kMaskRoot 			= 0x2,
		kMaskInterior		= 0x4,
		kMaskLeaf			= 0x8,
		kMaskLight			= 0x10,
		kMaskCurveOnSurface	= 0x20,
		kMaskCamera			= 0x40,
		kMaskLine			= 0x80,
		kMaskPoint  		= 0x100,
		kMaskEditPoint		= 0x200,
		kMaskMeshCurve		= 0x400,
		kMaskImagePlane     = 0x800,
		kMaskJoint          = 0x1000,
		kMaskCluster        = 0x2000,
		kMaskSelectionHandle= 0x4000,
		kMaskIKHandle		= 0x8000,
      kMaskSurfaceCurve	= 0x10000,
      kMaskCurve	      = 0x20000
	};

public:
	static API_BOOLEAN			isValid();

	static AlObject*		getObject();

	static AlDagNode*		getParentOfObject();

	static statusCode		firstPickItem();
	static statusCode		nextPickItem();
	static statusCode		prevPickItem();
	static statusCode		applyIteratorToItems( AlIterator*, int& );
	static statusCode		applyIteratorToItems( AlIteratorWithParent*, int& );

	static statusCode		clearPickList();
	static statusCode		pickByName( char* );
	static statusCode		pickFromScreen( Screencoord x, Screencoord y );
   static statusCode		pickChainFromScreen( Screencoord x, Screencoord y );
	static statusCode		pickAreaFromScreen( Screencoord x1, Screencoord y1, Screencoord x2, Screencoord y2 );
   static statusCode		pickChainAreaFromScreen( Screencoord x1, Screencoord y1, Screencoord x2, Screencoord y2 );

	static statusCode		pushPickList(API_BOOLEAN);
	static statusCode		popPickList();

	static statusCode		setPickMask( int );
	static statusCode		getPickMask( int& );

	static statusCode		asynchronousPick( AlUserPickList& );

private:
	static void				invalidate( void );
	static void				initMessages( void );
	static void				finiMessages( void );
	static API_BOOLEAN			canMakeObject( Pick_item* );
	static AlObject*		constructObject( Pick_item* );

	static statusCode		applyIteratorTypeToItems( AlIterator*, AlIteratorWithParent*, int& );

	static Pick_item*		fPickItem;
	static IR_ShaderEntry*	fPickShader;
	static AlList* 			PickListIDs;
};

#endif	/* _AlPickList_h */
