/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//+
//
//	.NAME AlPersistentID - A class for maintaining a persistent ID on an object
//
//	.SECTION Description
//
//		Sometimes it is necessary to maintain a persistent ID on an object.
//		The name of the object is inadequate for this since it may be changed
//		by the user, changed when the file is loaded, etc. The AlPersistentID
//		remains with the object through storing and retrieving, without ever
//		being changed.
//
//		This ID is not unique however. If the object is copied, or if a wire
//		file is retrieved more than once (into one or several stages) the ID
//		will be shared by all copies of the object.
//
//		Note that querying an ID from an object will actually return a copy
//		of the object's ID. This ensures that the ID for an object does not
//		get changed.
//
//		For efficiency, IDs are not created until the first time they are
//		queried for. As a result copies of an object made before its ID is
//		created will not have the same ID as the original object.
//

#ifndef _AlPersistentID
#define _AlPersistentID

#include <AlStyle.h>

class STUDIOAPI_DECL AlPersistentID
{
	public:
					AlPersistentID();
					AlPersistentID( AlPersistentID & );
					AlPersistentID( int, int = -1, int = -1, int = -1 );
		virtual		~AlPersistentID();

		AlPersistentID	&operator=( const AlPersistentID& );
		void		id( int &, int &, int &, int & );

		friend int	operator== (const AlPersistentID &, const AlPersistentID &);
		friend int	operator!= (const AlPersistentID &, const AlPersistentID &);

	private:
		int			fIdentifier0;
		int			fIdentifier1;
		int			fIdentifier2;
		int			fIdentifier3;
};

#endif
