/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

/*
//	.NAME AlPerformance - Interface to Alias performance options
//
//	.SECTION Description
//		This class encapsulates all access to the Alias performance
//		options.  Every value in the window can be retrieved and set.
//
//		Note: displayables are objects such as locators.
//
*/

#ifndef _AlPerformance_h
#define _AlPerformance_h

#include <AlStyle.h>

class STUDIOAPI_DECL AlPerformance
{
public:

	enum AlPrecisionType {
		kActual,
		kScreenSize,
		kMedium,
		kLow,
		kConnectedPoints,
		kBoundary,
		kBoundingBox
	};

public:
	static AlPrecisionType	redrawPrecision( void );
	static void				setRedrawPrecision( AlPrecisionType );

	static AlPrecisionType	motionPrecision( void );
	static void				setMotionPrecision( AlPrecisionType );

	static int			evaluationsPerUpdate( void );
	static void			setEvaluationsPerUpdate( int );

	static API_BOOLEAN 		drawTrimBoundaries( void );
	static void			setDrawTrimBoundaries( API_BOOLEAN );

	static API_BOOLEAN 		trimBoundariesDuringPlayback( void );
	static void			setTrimBoundariesDuringPlayback( API_BOOLEAN );


	static API_BOOLEAN		expressionsAfterModification( void );
	static void			setExpressionsAfterModification( API_BOOLEAN );

	static API_BOOLEAN		expressionsDuringXform( void );
	static void			setExpressionsDuringXform( API_BOOLEAN );

	static API_BOOLEAN		expressionsDuringPlayback( void );
	static void			setExpressionsDuringPlayback( API_BOOLEAN );


	static API_BOOLEAN		constraintsAfterModification( void );
	static void			setConstraintsAfterModification( API_BOOLEAN );

	static API_BOOLEAN		constraintsDuringXform( void );
	static void			setConstraintsDuringXform( API_BOOLEAN );

	static API_BOOLEAN		constraintsDuringPlayback( void );
	static void			setConstraintsDuringPlayback( API_BOOLEAN );


	static API_BOOLEAN		ikAfterModification( void );
	static void			setIkAfterModification( API_BOOLEAN );

	static API_BOOLEAN		ikDuringXform( void );
	static void			setIkDuringXform( API_BOOLEAN );

	static API_BOOLEAN		ikDuringPlayback( void );
	static void			setIkDuringPlayback( API_BOOLEAN );


	static API_BOOLEAN		constructionHistoryAfterModification( void );
	static void			setConstructionHistoryAfterModification( API_BOOLEAN );

	static API_BOOLEAN		constructionHistoryDuringXform( void );
	static void			setConstructionHistoryDuringXform( API_BOOLEAN );

	static API_BOOLEAN		constructionHistoryDuringPlayback( void );
	static void			setConstructionHistoryDuringPlayback( API_BOOLEAN );

	static API_BOOLEAN		blendDuringPlayback( void );
	static void			setBlendDuringPlayback( API_BOOLEAN );

	static API_BOOLEAN		constructionHistoryRound( void );
	static void			setConstructionHistoryRound( API_BOOLEAN );


	static API_BOOLEAN		actionWindowAfterModification( void );
	static void			setActionWindowAfterModification( API_BOOLEAN );

	static API_BOOLEAN		actionWindowDuringXform( void );
	static void			setActionWindowDuringXform( API_BOOLEAN );


	static API_BOOLEAN		displayablesAfterModification( void );
	static void			setDisplayablesAfterModification( API_BOOLEAN );

	static API_BOOLEAN		displayablesDuringXform( void );
	static void			setDisplayablesDuringXform( API_BOOLEAN );

	static API_BOOLEAN		displayablesDuringPlayback( void );
	static void			setDisplayablesDuringPlayback( API_BOOLEAN );
};

#endif
