/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlOrthographicCamera  - orthographic modeling cameras.
//
//	.SECTION Description
//		This class provides an interface to orthographic cameras, primarily
//		so that one can manipulate the image planes on those cameras.  In
//		general, little can be done to ortho cameras, as they are more of
//		a modeling tool than geometry.  In that regard, this class contains
//		little functionality.
//
//		It is possible to create a new orthographic camera through the
//		create() call.  The valid parameters to that call are defined in
//		AlWindow.h.  Note that creating an orthographic camera automatically
//		creates the associated modeling window.
//

#ifndef _AlOrthographicCamera
#define _AlOrthographicCamera

#include <AlCamera.h>
#include <AlWindow.h>

typedef void *	Camera_ptr;

class STUDIOAPI_DECL AlOrthographicCamera	: public AlCamera
{

	friend class			AlFriend;
public:
							AlOrthographicCamera();
	virtual					~AlOrthographicCamera();
	virtual statusCode		deleteObject();
	virtual AlObject*  		copyWrapper() const;

	statusCode				create( AlWindow::AlViewType );

	virtual AlObjectType	type() const;

protected:
private:
};

#endif
