/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlOrientationConstraint
#define _AlOrientationConstraint

//
//	.NAME AlOrientationConstraint - Interface to IK orientation constraint data.
//
//	.SECTION Description
//		The AlOrientationConstraint class allows access to the IK
//		orientation constraint information on an AlJoint. This
//		class is derived from the AlConstraint class.
//
//		(See the discussion of skeletons, joints, contraints, ik, etc. in
//		the Alias Studio manuals for a full description.)
//

#include <AlConstraint.h>

class AlDagNode;

class STUDIOAPI_DECL AlOrientationConstraint : public AlConstraint {

public:

									AlOrientationConstraint();
	virtual 						~AlOrientationConstraint();

	virtual AlObject*				copyWrapper() const;

	statusCode						create(AlDagNode*, AlDagNode* );
	statusCode						create(AlDagNode*, AlDagNode*, double[2] );

	virtual AlObjectType			type() const;

	statusCode						goalX( double[3] ) const;
	statusCode						goalY( double[3] ) const;
	statusCode						goalZ( double[3] ) const;
};

#endif	/* _AlOrientationConstraint */
