/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//+
//
//	.NAME AlObserver - OpenAlias class that allows a plug-in to detect
//	selected Alias events.
//
//	.SECTION Description
//
//		AlObserver is a static OpenAlias class.  Currently, it allows a user to detect
//		when the Alias window is minimized, maximized, lowered and raised.
//		This class will	not be able to trap events that are handled by the 
//		Window Manager.
//		An example of an event that cannot be trapped is the raising 
//		of a window by clicking on the window bar.  But this situation 
//		can be detected with the use of an X event handler installed by the 
//		AlXevents class.  It would be necessary to test for your window 
//		being below the Alias window on ConfigureNotify events with the 
//		method AlXevents::belowAliasWindow().
//

#ifndef _AlObserver
#define  _AlObserver

#include <AlStyle.h>

class STUDIOAPI_DECL AlObserver
{
public:

	enum ObserverMessage
	{
		kMaximizeWindow,
		kMinimizeWindow,
		kLowerWindow,
		kRaiseWindow
	};

	static statusCode		create();
	static statusCode		deleteObject();
	static statusCode		installHandler( ObserverMessage, void (*)(void) );
	static statusCode		removeHandler( ObserverMessage, void (*)(void) );

};

#endif // _AlObserver
