/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlNotifyDagNode - Encapsulates the handling of dag node notifications
//
//	.SECTION Description
//		This class provides a means for an application function to notify
//		Alias of a list of possible dag nodes that will be affected if an
//		object is modified.
//
//	This class is passed to the application function along with an AlObject.
//	For each dag node that is affected if the AlObject is modifed, the
//	application should call AlNotifyDagNode::notify.
//
//	This is a restricted version of an iterator which can only be applied
//	to AlDagNodes.
//

#ifndef _AlNotifyDagNode
#define _AlNotifyDagNode

#include <AlStyle.h>

class AlDagNode;
class STUDIOAPI_DECL AlNotifyDagNode {
	friend class AlFriend;

public:
	virtual statusCode notify( AlDagNode * ) const;

protected:
	AlNotifyDagNode()			{};
	virtual ~AlNotifyDagNode()	{};
};

#endif // AlNotifyDagNode
